/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.filter;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyInvocation;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.GsonUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"server", "consumer"})
public class DubboHmilyTransactionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboHmilyTransactionFilter.class);
    private HmilyTransactionExecutor hmilyTransactionExecutor;

    public void setHmilyTransactionExecutor(HmilyTransactionExecutor hmilyTransactionExecutor) {
        this.hmilyTransactionExecutor = hmilyTransactionExecutor;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String methodName = invocation.getMethodName();
        Class clazz = invoker.getInterface();
        Class[] args = invocation.getParameterTypes();
        Object[] arguments = invocation.getArguments();
        Method method = null;
        Hmily hmily = null;
        try {
            this.converterParamsClass(args, arguments);
            method = clazz.getMethod(methodName, args);
            hmily = method.getAnnotation(Hmily.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtil.error((Logger)LOGGER, (String)"hmily find method error {} ", ex::getMessage);
        }
        if (Objects.nonNull(hmily)) {
            try {
                HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
                if (Objects.nonNull(hmilyTransactionContext)) {
                    if (hmilyTransactionContext.getRole() == HmilyRoleEnum.LOCAL.getCode()) {
                        hmilyTransactionContext.setRole(HmilyRoleEnum.INLINE.getCode());
                    }
                    RpcContext.getContext().setAttachment("HMILY_TRANSACTION_CONTEXT", GsonUtils.getInstance().toJson((Object)hmilyTransactionContext));
                    Result result = invoker.invoke(invocation);
                    if (!result.hasException()) {
                        HmilyParticipant hmilyParticipant = this.buildParticipant(hmilyTransactionContext, hmily, method, clazz, arguments, args);
                        if (hmilyTransactionContext.getRole() == HmilyRoleEnum.INLINE.getCode()) {
                            this.hmilyTransactionExecutor.registerByNested(hmilyTransactionContext.getTransId(), hmilyParticipant);
                        } else {
                            this.hmilyTransactionExecutor.enlistParticipant(hmilyParticipant);
                        }
                    } else {
                        throw new HmilyRuntimeException("rpc invoke exception{}", result.getException());
                    }
                    return result;
                }
                return invoker.invoke(invocation);
            }
            catch (RpcException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return invoker.invoke(invocation);
    }

    private HmilyParticipant buildParticipant(HmilyTransactionContext hmilyTransactionContext, Hmily hmily, Method method, Class clazz, Object[] arguments, Class ... args) throws HmilyRuntimeException {
        String cancelMethodName;
        if (Objects.isNull(hmilyTransactionContext) || HmilyActionEnum.TRYING.getCode() != hmilyTransactionContext.getAction()) {
            return null;
        }
        String confirmMethodName = hmily.confirmMethod();
        if (StringUtils.isBlank((CharSequence)confirmMethodName)) {
            confirmMethodName = method.getName();
        }
        if (StringUtils.isBlank((CharSequence)(cancelMethodName = hmily.cancelMethod()))) {
            cancelMethodName = method.getName();
        }
        HmilyInvocation confirmInvocation = new HmilyInvocation(clazz, confirmMethodName, args, arguments);
        HmilyInvocation cancelInvocation = new HmilyInvocation(clazz, cancelMethodName, args, arguments);
        return new HmilyParticipant(hmilyTransactionContext.getTransId(), confirmInvocation, cancelInvocation);
    }

    private void converterParamsClass(Class[] args, Object[] arguments) {
        if (arguments == null || arguments.length < 1) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) continue;
            args[i] = arguments[i].getClass();
        }
    }
}

