/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.interceptor;

import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.rpc.RpcContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.utils.GsonUtils;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.interceptor.HmilyTransactionInterceptor;
import org.dromara.hmily.core.service.HmilyTransactionAspectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DubboHmilyTransactionInterceptor
implements HmilyTransactionInterceptor {
    private final HmilyTransactionAspectService hmilyTransactionAspectService;

    @Autowired
    public DubboHmilyTransactionInterceptor(HmilyTransactionAspectService hmilyTransactionAspectService) {
        this.hmilyTransactionAspectService = hmilyTransactionAspectService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        HmilyTransactionContext hmilyTransactionContext;
        String context = RpcContext.getContext().getAttachment("HMILY_TRANSACTION_CONTEXT");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{context})) {
            hmilyTransactionContext = (HmilyTransactionContext)GsonUtils.getInstance().fromJson(context, HmilyTransactionContext.class);
            RpcContext.getContext().getAttachments().remove("HMILY_TRANSACTION_CONTEXT");
        } else {
            hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        }
        return this.hmilyTransactionAspectService.invoke(hmilyTransactionContext, pjp);
    }
}

