/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.loadbalance;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.loadbalance.AbstractLoadBalance;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;

public class DubboHmilyLoadBalance
extends AbstractLoadBalance {
    private static final Map<String, URL> URL_MAP = Maps.newConcurrentMap();
    private final Random random = new Random();

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        Invoker<T> invoker = invokers.get(this.random.nextInt(invokers.size()));
        HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        if (Objects.isNull(hmilyTransactionContext)) {
            return invoker;
        }
        String transId = hmilyTransactionContext.getTransId();
        if (hmilyTransactionContext.getAction() == HmilyActionEnum.TRYING.getCode()) {
            URL_MAP.put(transId, invoker.getUrl());
            return invoker;
        }
        URL orlUrl = URL_MAP.get(transId);
        URL_MAP.remove(transId);
        if (Objects.nonNull(orlUrl)) {
            for (Invoker<T> inv : invokers) {
                if (!Objects.equals(inv.getUrl(), orlUrl)) continue;
                return inv;
            }
        }
        return invoker;
    }
}

