/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.filter;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.core.mediator.RpcMediator;
import org.dromara.hmily.repository.spi.entity.HmilyInvocation;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class DubboHmilyTransactionFilter
implements Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboHmilyTransactionFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        HmilyTransactionContext context = HmilyContextHolder.get();
        if (Objects.isNull(context)) {
            return invoker.invoke(invocation);
        }
        Class clazz = invoker.getInterface();
        Class[] args = invocation.getParameterTypes();
        String methodName = invocation.getMethodName();
        try {
            Method method = clazz.getMethod(methodName, args);
            Hmily hmily = method.getAnnotation(Hmily.class);
            if (Objects.isNull(hmily)) {
                return invoker.invoke(invocation);
            }
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOGGER, (String)"hmily find method error {} ", ex::getMessage);
            return invoker.invoke(invocation);
        }
        Object[] arguments = invocation.getArguments();
        this.converterParamsClass(args, arguments);
        Long participantId = context.getParticipantId();
        HmilyParticipant hmilyParticipant = this.buildParticipant(context, invoker, invocation);
        Optional.ofNullable(hmilyParticipant).ifPresent(participant -> context.setParticipantId(participant.getParticipantId()));
        if (context.getRole() == HmilyRoleEnum.PARTICIPANT.getCode()) {
            context.setParticipantRefId(participantId);
        }
        RpcMediator.getInstance().transmit((arg_0, arg_1) -> ((RpcContext)RpcContext.getContext()).setAttachment(arg_0, arg_1), context);
        Result result = invoker.invoke(invocation);
        if (!result.hasException()) {
            if (context.getRole() == HmilyRoleEnum.PARTICIPANT.getCode()) {
                HmilyTransactionHolder.getInstance().registerParticipantByNested(participantId, hmilyParticipant);
            } else {
                HmilyTransactionHolder.getInstance().registerStarterParticipant(hmilyParticipant);
            }
        } else {
            throw new HmilyRuntimeException("rpc invoke exception{}", result.getException());
        }
        return result;
    }

    private HmilyParticipant buildParticipant(HmilyTransactionContext context, Invoker<?> invoker, Invocation invocation) throws HmilyRuntimeException {
        if (HmilyActionEnum.TRYING.getCode() != context.getAction()) {
            return null;
        }
        HmilyParticipant hmilyParticipant = new HmilyParticipant();
        hmilyParticipant.setTransId(context.getTransId());
        hmilyParticipant.setParticipantId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        hmilyParticipant.setTransType(context.getTransType());
        String methodName = invocation.getMethodName();
        Class clazz = invoker.getInterface();
        Class[] args = invocation.getParameterTypes();
        Object[] arguments = invocation.getArguments();
        HmilyInvocation hmilyInvocation = new HmilyInvocation(clazz, methodName, args, arguments);
        hmilyParticipant.setConfirmHmilyInvocation(hmilyInvocation);
        hmilyParticipant.setCancelHmilyInvocation(hmilyInvocation);
        return hmilyParticipant;
    }

    private void converterParamsClass(Class<?>[] args, Object[] arguments) {
        if (arguments == null || arguments.length < 1) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) continue;
            args[i] = arguments[i].getClass();
        }
    }
}

