/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.enums;

import java.util.Arrays;
import org.dromara.hmily.common.exception.HmilyRuntimeException;

public enum EventTypeEnum {
    CREATE_HMILY_TRANSACTION(10, "\u521b\u5efa\u5168\u5c40\u4e8b\u52a1"),
    UPDATE_HMILY_TRANSACTION_STATUS(11, "\u66f4\u65b0\u5168\u5c40\u4e8b\u52a1\u72b6\u6001"),
    REMOVE_HMILY_TRANSACTION(12, "\u5220\u9664\u5168\u5c40\u65e5\u5fd7"),
    CREATE_HMILY_PARTICIPANT(20, "\u521b\u5efa\u53c2\u4e0e\u8005"),
    UPDATE_HMILY_PARTICIPANT_STATUS(21, "\u66f4\u65b0\u53c2\u4e0e\u8005\u72b6\u6001"),
    REMOVE_HMILY_PARTICIPANT(22, "\u5220\u9664\u53c2\u4e0e\u8005\u65e5\u5fd7"),
    REMOVE_HMILY_PARTICIPANT_UNDO(30, "\u5220\u9664undo\u65e5\u5fd7"),
    CREATE_HMILY_PARTICIPANT_UNDO(31, "\u521b\u5efaundo\u65e5\u5fd7"),
    UPDATE_STATUS(30, "\u66f4\u65b0\u72b6\u6001"),
    UPDATE_PARTICIPANT(40, "\u66f4\u65b0\u53c2\u4e0e\u8005");

    private final int code;
    private final String desc;

    public static EventTypeEnum buildByCode(int code) {
        return Arrays.stream(EventTypeEnum.values()).filter(e -> e.code == code).findFirst().orElseThrow(() -> new HmilyRuntimeException("can not support this code!"));
    }

    private EventTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

