/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum RepositorySupportEnum {
    MYSQL("mysql"),
    ORACLE("oracle"),
    SQL_SERVER("sqlServer"),
    POSTGRESQL("postgresql"),
    FILE("file"),
    REDIS("redis"),
    MONGODB("mongodb"),
    ZOOKEEPER("zookeeper");

    private final String support;

    public static RepositorySupportEnum acquire(String support) {
        Optional<RepositorySupportEnum> repositorySupportEnum = Arrays.stream(RepositorySupportEnum.values()).filter(v -> Objects.equals(v.getSupport(), support)).findFirst();
        return repositorySupportEnum.orElse(MYSQL);
    }

    private RepositorySupportEnum(String support) {
        this.support = support;
    }

    public String getSupport() {
        return this.support;
    }
}

