/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.hook;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.hmily.common.utils.CollectionUtils;

public final class HmilyShutdownHook
extends Thread {
    private static final HmilyShutdownHook INSTANCE = new HmilyShutdownHook("HmilyShutdownHook");
    private final Set<AutoCloseable> autoCloseableHashSet = new HashSet<AutoCloseable>();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    private HmilyShutdownHook(String name) {
        super(name);
    }

    public static HmilyShutdownHook getInstance() {
        return INSTANCE;
    }

    public void registerAutoCloseable(AutoCloseable autoCloseable) {
        this.autoCloseableHashSet.add(autoCloseable);
    }

    @Override
    public void run() {
        this.closeAll();
    }

    private void closeAll() {
        if (!this.destroyed.compareAndSet(false, true) && CollectionUtils.isEmpty(this.autoCloseableHashSet)) {
            return;
        }
        for (AutoCloseable autoCloseable : this.autoCloseableHashSet) {
            autoCloseable.close();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(INSTANCE);
    }
}

