/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.lang3.StringUtils;

public class GsonUtils {
    private static final GsonUtils INSTANCE = new GsonUtils();
    private static final TypeAdapter<String> STRING = new TypeAdapter<String>(){

        public void write(JsonWriter out, String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                out.nullValue();
                return;
            }
            out.value(value);
        }

        public String read(JsonReader reader) {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return "";
            }
            return reader.nextString();
        }
    };
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(String.class, STRING).create();
    private static final Gson GSON_MAP = new GsonBuilder().serializeNulls().registerTypeHierarchyAdapter(new TypeToken<Map<String, Object>>(){}.getRawType(), new MapDeserializer()).create();
    private static final String DOT = ".";
    private static final String E = "e";

    public static Gson getGson() {
        return GSON;
    }

    public static GsonUtils getInstance() {
        return INSTANCE;
    }

    public String toJson(Object object) {
        return GSON.toJson(object);
    }

    public <T> T fromJson(String json, Class<T> tClass) {
        return (T)GSON.fromJson(json, tClass);
    }

    public <T> T fromJson(JsonElement jsonElement, Class<T> tClass) {
        return (T)GSON.fromJson(jsonElement, tClass);
    }

    public <T> List<T> fromList(String json, Class<T> clazz) {
        return (List)GSON.fromJson(json, TypeToken.getParameterized(List.class, (Type[])new Type[]{clazz}).getType());
    }

    private Map<String, String> toStringMap(String json) {
        return (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
    }

    public List<Map<String, Object>> toListMap(String json) {
        return (List)GSON.fromJson(json, new TypeToken<List<Map<String, Object>>>(){}.getType());
    }

    public Map<String, Object> toObjectMap(String json) {
        return (Map)GSON_MAP.fromJson(json, new TypeToken<LinkedHashMap<String, Object>>(){}.getType());
    }

    public ConcurrentSkipListMap<String, Object> toTreeMap(String json) {
        return (ConcurrentSkipListMap)GSON_MAP.fromJson(json, new TypeToken<ConcurrentSkipListMap<String, Object>>(){}.getType());
    }

    private static class MapDeserializer<T, U>
    implements JsonDeserializer<Map<T, U>> {
        private MapDeserializer() {
        }

        public Map<T, U> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                return null;
            }
            JsonObject jsonObject = json.getAsJsonObject();
            Set jsonEntrySet = jsonObject.entrySet();
            LinkedHashMap resultMap = new LinkedHashMap();
            for (Map.Entry entry : jsonEntrySet) {
                Object value = context.deserialize((JsonElement)entry.getValue(), (Type)this.getType((JsonElement)entry.getValue()));
                resultMap.put(entry.getKey(), value);
            }
            return resultMap;
        }

        public Class getType(JsonElement element) {
            if (!element.isJsonPrimitive()) {
                return element.getClass();
            }
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isString()) {
                return String.class;
            }
            if (primitive.isNumber()) {
                String numStr = primitive.getAsString();
                if (numStr.contains(GsonUtils.DOT) || numStr.contains(GsonUtils.E) || numStr.contains("E")) {
                    return Double.class;
                }
                return Long.class;
            }
            if (primitive.isBoolean()) {
                return Boolean.class;
            }
            return element.getClass();
        }
    }
}

