/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.common.utils;

import java.security.CodeSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionUtils.class);
    private static final String VERSION = VersionUtils.getVersion(VersionUtils.class, "1.0.0");

    private VersionUtils() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            String version = cls.getPackage().getImplementationVersion();
            if (version == null || version.length() == 0) {
                version = cls.getPackage().getSpecificationVersion();
            }
            if (version == null || version.length() == 0) {
                CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    LOGGER.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
                } else {
                    String file = codeSource.getLocation().getFile();
                    if (file != null && file.length() > 0 && file.endsWith(".jar")) {
                        int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
                        if (i >= 0) {
                            file = file.substring(i + 1);
                        }
                        if ((i = file.indexOf("-")) >= 0) {
                            file = file.substring(i + 1);
                        }
                        while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                            file = file.substring(i + 1);
                        }
                        version = file;
                    }
                }
            }
            return version == null || version.length() == 0 ? defaultVersion : version;
        }
        catch (Exception e) {
            LOGGER.error("return default version, ignore exception " + e.getMessage(), (Throwable)e);
            return defaultVersion;
        }
    }
}

