/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.consul;

import com.google.common.net.HostAndPort;
import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.cache.KVCache;
import com.orbitz.consul.model.kv.Value;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.consul.ConsulConfig;
import org.dromara.hmily.config.consul.ConsulPassiveConfig;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsulClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulClient.class);
    private Consul consul;

    private ConsulClient() {
    }

    public void setConsul(Consul consul) {
        this.consul = consul;
    }

    public static ConsulClient getInstance(ConsulConfig consulConfig) {
        Consul consul;
        String hostAndPorts = consulConfig.getHostAndPorts();
        List<HostAndPort> hostAndPortList = ConsulClient.buildHostAndPortList(hostAndPorts);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulConfig.getHostAndPorts()})) {
            Consul.builder().withMultipleHostAndPort(hostAndPortList, consulConfig.getBlacklistTimeInMillis()).build();
            consul = Consul.newClient();
        } else {
            Consul.builder().withHostAndPort(HostAndPort.fromString((String)consulConfig.getHostAndPort())).build();
            consul = Consul.newClient();
        }
        ConsulClient consulClient = new ConsulClient();
        consulClient.setConsul(consul);
        return consulClient;
    }

    private static List<HostAndPort> buildHostAndPortList(String hostAndPorts) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{hostAndPorts})) {
            String[] hostAndPortArray = hostAndPorts.split(",");
            ArrayList<HostAndPort> hostAndPortList = new ArrayList<HostAndPort>();
            for (String hostAndPort : hostAndPortArray) {
                hostAndPortList.add(HostAndPort.fromString((String)hostAndPort));
            }
            return hostAndPortList;
        }
        return Collections.emptyList();
    }

    public InputStream pull(ConsulConfig consulConfig) {
        Value value;
        if (this.consul == null) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{consulConfig.getHostAndPorts()})) {
                Consul.builder().withMultipleHostAndPort(ConsulClient.buildHostAndPortList(consulConfig.getHostAndPorts()), consulConfig.getBlacklistTimeInMillis()).build();
                this.consul = Consul.newClient();
            } else {
                Consul.builder().withHostAndPort(HostAndPort.fromString((String)consulConfig.getHostAndPort())).build();
                this.consul = Consul.newClient();
            }
        }
        if ((value = (Value)this.consul.keyValueClient().getValue(consulConfig.getKey()).orElse(null)) == null) {
            return null;
        }
        String content = (String)value.getValueAsString(Charset.forName("utf-8")).get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("consul content {}", (Object)content);
        }
        if (StringUtils.isBlank((CharSequence)content)) {
            return null;
        }
        return new ByteArrayInputStream(content.getBytes(Charset.forName("utf-8")));
    }

    public void put(String key, String content) {
        this.consul.keyValueClient().putValue(key, content);
    }

    void addListener(Supplier<ConfigLoader.Context> context, ConfigLoader.PassiveHandler<ConsulPassiveConfig> passiveHandler, ConsulConfig config) throws InterruptedException {
        if (!config.isPassive()) {
            return;
        }
        if (this.consul == null) {
            LOGGER.warn("Consul client is null...");
        }
        KVCache consulCache = KVCache.newCache((KeyValueClient)this.consul.keyValueClient(), (String)config.getKey());
        consulCache.addListener(map -> {
            Set set = map.entrySet();
            set.forEach(arg_0 -> ConsulClient.lambda$null$0(config, passiveHandler, (Supplier)context, arg_0));
        });
        consulCache.start();
        LOGGER.info("passive consul remote started....");
    }

    private static /* synthetic */ void lambda$null$0(ConsulConfig config, ConfigLoader.PassiveHandler passiveHandler, Supplier context, Map.Entry x) {
        ConsulPassiveConfig consulPassiveConfig = new ConsulPassiveConfig();
        consulPassiveConfig.setKey(config.getKey());
        consulPassiveConfig.setFileExtension(config.getFileExtension());
        consulPassiveConfig.setValue((String)((Value)x.getValue()).getValueAsString(Charset.forName("utf-8")).get());
        passiveHandler.passive(context, (Config)consulPassiveConfig);
    }
}

