/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.etcd;

import com.coreos.jetcd.Client;
import com.coreos.jetcd.data.ByteSequence;
import com.coreos.jetcd.data.KeyValue;
import com.coreos.jetcd.kv.GetResponse;
import com.coreos.jetcd.watch.WatchEvent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.api.event.AddData;
import org.dromara.hmily.config.api.event.EventData;
import org.dromara.hmily.config.api.event.RemoveData;
import org.dromara.hmily.config.api.exception.ConfigException;
import org.dromara.hmily.config.etcd.EtcdConfig;
import org.dromara.hmily.config.etcd.EtcdPassiveConfig;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdClient.class);
    private Client client;

    public InputStream pull(EtcdConfig config) {
        Client client = Client.builder().endpoints(new String[]{config.getServer()}).build();
        try {
            CompletableFuture future = client.getKVClient().get(ByteSequence.fromString((String)config.getKey()));
            List kvs = config.getTimeoutMs() > 0L ? ((GetResponse)future.get(config.getTimeoutMs(), TimeUnit.MILLISECONDS)).getKvs() : ((GetResponse)future.get()).getKvs();
            if (CollectionUtils.isNotEmpty((Collection)kvs)) {
                String content = ((KeyValue)kvs.get(0)).getValue().toStringUtf8();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("etcd content {}", (Object)content);
                }
                if (StringUtils.isBlank((CharSequence)content)) {
                    return null;
                }
                return new ByteArrayInputStream(content.getBytes());
            }
            return null;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new ConfigException((Throwable)e);
        }
    }

    void addListener(Supplier<ConfigLoader.Context> context, ConfigLoader.PassiveHandler<EtcdPassiveConfig> passiveHandler, EtcdConfig config) throws InterruptedException {
        if (!config.isPassive()) {
            return;
        }
        if (this.client == null) {
            LOGGER.warn("Etcd client is null...");
        }
        this.client.getWatchClient().watch(ByteSequence.fromString((String)config.getKey())).listen().getEvents().stream().forEach(watchEvent -> {
            WatchEvent.EventType eventType = watchEvent.getEventType();
            KeyValue keyValue = watchEvent.getKeyValue();
            KeyValue prevKV = watchEvent.getPrevKV();
            RemoveData eventData = null;
            switch (eventType) {
                case PUT: {
                    eventData = new AddData(keyValue.getKey().toStringUtf8(), (Object)keyValue.getValue().toStringUtf8());
                    break;
                }
                case DELETE: {
                    eventData = new RemoveData(prevKV.getKey().toStringUtf8(), null);
                    break;
                }
            }
            Optional.of(eventData).ifPresent(arg_0 -> EtcdClient.lambda$null$0(config, passiveHandler, (Supplier)context, arg_0));
        });
        LOGGER.info("passive Etcd remote started....");
    }

    private static /* synthetic */ void lambda$null$0(EtcdConfig config, ConfigLoader.PassiveHandler passiveHandler, Supplier context, EventData e) {
        EtcdPassiveConfig etcdPassiveConfig = new EtcdPassiveConfig();
        etcdPassiveConfig.setKey(config.getKey());
        etcdPassiveConfig.setFileExtension(config.getFileExtension());
        etcdPassiveConfig.setValue(e);
        passiveHandler.passive(context, (Config)etcdPassiveConfig);
    }
}

