/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.etcd;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.api.exception.ConfigException;
import org.dromara.hmily.config.etcd.EtcdClient;
import org.dromara.hmily.config.etcd.EtcdConfig;
import org.dromara.hmily.config.etcd.EtcdPassiveConfig;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.dromara.hmily.config.loader.PropertyLoader;
import org.dromara.hmily.config.loader.properties.PropertiesLoader;
import org.dromara.hmily.config.loader.yaml.YamlPropertyLoader;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="etcd")
public class EtcdConfigLoader
implements ConfigLoader<EtcdConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdConfigLoader.class);
    private static final Map<String, PropertyLoader> LOADERS = new HashMap<String, PropertyLoader>();
    private EtcdClient client = new EtcdClient();

    public EtcdConfigLoader() {
    }

    public EtcdConfigLoader(EtcdClient client) {
        this();
        this.client = client;
    }

    public void load(Supplier<ConfigLoader.Context> context, ConfigLoader.LoaderHandler<EtcdConfig> handler) {
        ConfigLoader.LoaderHandler etcdHandler = (c, config) -> this.etcdLoad(c, handler, (EtcdConfig)config);
        this.againLoad(context, etcdHandler, EtcdConfig.class);
    }

    public void passive(Supplier<ConfigLoader.Context> context, ConfigLoader.PassiveHandler<Config> handler, Config config) {
        if (config.isPassive()) {
            try {
                this.client.addListener(context, (ConfigLoader.PassiveHandler<EtcdPassiveConfig>)((ConfigLoader.PassiveHandler)(c, cfg) -> this.push(c, cfg.getValue())), (EtcdConfig)config);
            }
            catch (InterruptedException e) {
                throw new ConfigException("etcd passive config failed.");
            }
        }
    }

    private void etcdLoad(Supplier<ConfigLoader.Context> context, ConfigLoader.LoaderHandler<EtcdConfig> handler, EtcdConfig config) {
        PropertyLoader propertyLoader;
        String fileExtension;
        if (config != null) {
            this.check(config);
            LOGGER.info("loader etcd config: {}", (Object)config);
            fileExtension = config.getFileExtension();
            propertyLoader = LOADERS.get(fileExtension);
            if (propertyLoader == null) {
                throw new ConfigException("etcd.fileExtension setting error, The loader was not found");
            }
        } else {
            throw new ConfigException("etcd config is null");
        }
        InputStream pull = this.client.pull(config);
        Optional.ofNullable(pull).map(e -> propertyLoader.load("remote.etcd." + fileExtension, e)).ifPresent(e -> ((ConfigLoader.Context)context.get()).getOriginal().load(() -> EtcdConfigLoader.lambda$null$3((Supplier)context, e), this::etcdFinish));
        handler.finish(context, (Config)config);
        this.passive(context, null, (Config)config);
    }

    private void etcdFinish(Supplier<ConfigLoader.Context> context, Config config) {
        LOGGER.info("etcd loader config {}:{}", (Object)(config != null ? config.prefix() : ""), (Object)config);
    }

    private void check(EtcdConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getServer())) {
            throw new ConfigException("etcd.server is null");
        }
        if (StringUtils.isBlank((CharSequence)config.getFileExtension())) {
            throw new ConfigException("etcd.fileExtension is null");
        }
        if (StringUtils.isBlank((CharSequence)config.getKey())) {
            throw new ConfigException("etcd.key is null");
        }
    }

    private static /* synthetic */ ConfigLoader.Context lambda$null$3(Supplier context, List e) {
        return ((ConfigLoader.Context)context.get()).withSources(e);
    }

    static {
        LOADERS.put("yml", (PropertyLoader)new YamlPropertyLoader());
        LOADERS.put("properties", (PropertyLoader)new PropertiesLoader());
    }
}

