/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.api.exception.ConfigException;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.dromara.hmily.config.nacos.NacosConfig;
import org.dromara.hmily.config.nacos.NacosPassiveConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosClient.class);
    private static final String NACOS_SERVER_ADDR_KEY = "serverAddr";
    private ConfigService configService;

    InputStream pull(NacosConfig config) {
        Properties properties = new Properties();
        properties.put(NACOS_SERVER_ADDR_KEY, config.getServer());
        try {
            this.configService = NacosFactory.createConfigService((Properties)properties);
            String content = this.configService.getConfig(config.getDataId(), config.getGroup(), config.getTimeoutMs());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("nacos content {}", (Object)content);
            }
            if (StringUtils.isBlank((CharSequence)content)) {
                return null;
            }
            return new ByteArrayInputStream(content.getBytes());
        }
        catch (NacosException e) {
            throw new ConfigException((Throwable)e);
        }
    }

    void addListener(final Supplier<ConfigLoader.Context> context, final ConfigLoader.PassiveHandler<NacosPassiveConfig> passiveHandler, final NacosConfig config) throws NacosException {
        if (!config.isPassive()) {
            return;
        }
        if (this.configService == null) {
            LOGGER.warn("nacos configService is null...");
        }
        this.configService.addListener(config.getDataId(), config.getGroup(), new Listener(){

            public Executor getExecutor() {
                return null;
            }

            public void receiveConfigInfo(String s) {
                NacosPassiveConfig nacosPassiveConfig = new NacosPassiveConfig();
                nacosPassiveConfig.setValue(s);
                nacosPassiveConfig.setFileExtension(config.getFileExtension());
                nacosPassiveConfig.setDataId(config.getDataId());
                passiveHandler.passive(context, (Config)nacosPassiveConfig);
            }
        });
        LOGGER.info("passive nacos remote started....");
    }
}

