/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.config.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.config.api.Config;
import org.dromara.hmily.config.api.ConfigEnv;
import org.dromara.hmily.config.api.event.AddData;
import org.dromara.hmily.config.api.event.EventData;
import org.dromara.hmily.config.api.event.ModifyData;
import org.dromara.hmily.config.api.exception.ConfigException;
import org.dromara.hmily.config.loader.ConfigLoader;
import org.dromara.hmily.config.loader.PropertyLoader;
import org.dromara.hmily.config.loader.properties.PropertiesLoader;
import org.dromara.hmily.config.loader.property.PropertyKeySource;
import org.dromara.hmily.config.loader.yaml.YamlPropertyLoader;
import org.dromara.hmily.config.nacos.NacosClient;
import org.dromara.hmily.config.nacos.NacosConfig;
import org.dromara.hmily.config.nacos.NacosPassiveConfig;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="nacos")
public class NacosConfigLoader
implements ConfigLoader<NacosConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosConfigLoader.class);
    private static final Map<String, PropertyLoader> LOADERS = new HashMap<String, PropertyLoader>();
    private NacosClient client = new NacosClient();

    public NacosConfigLoader() {
    }

    public NacosConfigLoader(NacosClient client) {
        this();
        this.client = client;
    }

    public void load(Supplier<ConfigLoader.Context> context, ConfigLoader.LoaderHandler<NacosConfig> handler) {
        ConfigLoader.LoaderHandler nacosHandler = (c, config) -> this.nacosLoad(c, handler, (NacosConfig)config);
        this.againLoad(context, nacosHandler, NacosConfig.class);
    }

    public void passive(Supplier<ConfigLoader.Context> context, ConfigLoader.PassiveHandler<Config> handler, Config config) {
        if (config instanceof NacosPassiveConfig) {
            NacosPassiveConfig nacosPassiveConfig = (NacosPassiveConfig)config;
            String value = nacosPassiveConfig.getValue();
            if (StringUtils.isBlank((CharSequence)value)) {
                return;
            }
            PropertyLoader propertyLoader = LOADERS.get(nacosPassiveConfig.getFileExtension());
            if (propertyLoader == null) {
                throw new ConfigException("nacos.fileExtension setting error, The loader was not found");
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());
            Optional.of(inputStream).map(e -> propertyLoader.load(nacosPassiveConfig.fileName(), e)).ifPresent(e -> e.forEach(arg_0 -> this.lambda$null$5((Supplier)context, arg_0)));
        }
    }

    private void nacosLoad(Supplier<ConfigLoader.Context> context, ConfigLoader.LoaderHandler<NacosConfig> handler, NacosConfig config) {
        if (config != null) {
            this.check(config);
            LOGGER.info("loader nacos config: {}", (Object)config);
            String fileExtension = config.getFileExtension();
            PropertyLoader propertyLoader = LOADERS.get(fileExtension);
            if (propertyLoader == null) {
                throw new ConfigException("nacos.fileExtension setting error, The loader was not found");
            }
            InputStream pull = this.client.pull(config);
            Optional.ofNullable(pull).map(e -> propertyLoader.load(config.fileName(), e)).ifPresent(e -> ((ConfigLoader.Context)context.get()).getOriginal().load(() -> NacosConfigLoader.lambda$null$8((Supplier)context, e), this::nacosFinish));
            handler.finish(context, (Config)config);
            try {
                this.client.addListener(context, (ConfigLoader.PassiveHandler<NacosPassiveConfig>)((ConfigLoader.PassiveHandler)(c1, c2) -> this.passive(c1, null, c2)), config);
            }
            catch (NacosException e2) {
                LOGGER.error("passive nacos remote started error....");
            }
        } else {
            throw new ConfigException("nacos config is null");
        }
    }

    private void nacosFinish(Supplier<ConfigLoader.Context> context, Config config) {
        LOGGER.info("nacos loader config {}:{}", (Object)(config != null ? config.prefix() : ""), (Object)config);
    }

    private void check(NacosConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getServer())) {
            throw new ConfigException("nacos.server is null");
        }
        if (StringUtils.isBlank((CharSequence)config.getDataId())) {
            throw new ConfigException("nacos.dataId is null");
        }
        if (StringUtils.isBlank((CharSequence)config.getFileExtension())) {
            throw new ConfigException("nacos.fileExtension is null");
        }
        if (StringUtils.isBlank((CharSequence)config.getGroup())) {
            throw new ConfigException("nacos.group is null");
        }
    }

    private static /* synthetic */ ConfigLoader.Context lambda$null$8(Supplier context, List e) {
        return ((ConfigLoader.Context)context.get()).withSources(e);
    }

    private /* synthetic */ void lambda$null$5(Supplier context, PropertyKeySource x) {
        x.getKeys().forEach(arg_0 -> this.lambda$null$4(x, (Supplier)context, arg_0));
    }

    private /* synthetic */ void lambda$null$4(PropertyKeySource x, Supplier context, String t) {
        ConfigEnv.getInstance().stream().filter(c -> t.startsWith(c.prefix())).forEach(arg_0 -> this.lambda$null$3(t, x, (Supplier)context, arg_0));
    }

    private /* synthetic */ void lambda$null$3(String t, PropertyKeySource x, Supplier context, Config c) {
        Object o = c.getSource().get(t);
        AddData data = null;
        if (Objects.isNull(o)) {
            data = new AddData(t, x.getValue(t));
        } else if (!Objects.equals(o, x.getValue(t))) {
            data = new ModifyData(t, x.getValue(t));
        }
        this.push(context, (EventData)data);
    }

    static {
        LOADERS.put("yml", (PropertyLoader)new YamlPropertyLoader());
        LOADERS.put("properties", (PropertyLoader)new PropertiesLoader());
    }
}

