/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyInvocation;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.GsonUtils;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;

@Activate(group={"server", "consumer"})
public class DubboHmilyTransactionFilter
implements Filter {
    private HmilyTransactionExecutor hmilyTransactionExecutor;

    public void setHmilyTransactionExecutor(HmilyTransactionExecutor hmilyTransactionExecutor) {
        this.hmilyTransactionExecutor = hmilyTransactionExecutor;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String methodName = invocation.getMethodName();
        Class clazz = invoker.getInterface();
        Class[] args = invocation.getParameterTypes();
        Object[] arguments = invocation.getArguments();
        this.converterParamsClass(args, arguments);
        Method method = null;
        Hmily hmily = null;
        try {
            method = clazz.getMethod(methodName, args);
            hmily = method.getAnnotation(Hmily.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(hmily)) {
            try {
                Result result;
                HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
                if (Objects.nonNull(hmilyTransactionContext)) {
                    if (hmilyTransactionContext.getRole() == HmilyRoleEnum.LOCAL.getCode()) {
                        hmilyTransactionContext.setRole(HmilyRoleEnum.INLINE.getCode());
                    }
                    RpcContext.getContext().setAttachment("HMILY_TRANSACTION_CONTEXT", GsonUtils.getInstance().toJson((Object)hmilyTransactionContext));
                }
                if (!(result = invoker.invoke(invocation)).hasException()) {
                    HmilyParticipant hmilyParticipant = this.buildParticipant(hmilyTransactionContext, hmily, method, clazz, arguments, args);
                    if (hmilyTransactionContext.getRole() == HmilyRoleEnum.INLINE.getCode()) {
                        this.hmilyTransactionExecutor.registerByNested(hmilyTransactionContext.getTransId(), hmilyParticipant);
                    } else {
                        this.hmilyTransactionExecutor.enlistParticipant(hmilyParticipant);
                    }
                } else {
                    throw new HmilyRuntimeException("rpc invoke exception{}", result.getException());
                }
                return result;
            }
            catch (RpcException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return invoker.invoke(invocation);
    }

    private HmilyParticipant buildParticipant(HmilyTransactionContext hmilyTransactionContext, Hmily hmily, Method method, Class clazz, Object[] arguments, Class ... args) throws HmilyRuntimeException {
        String cancelMethodName;
        if (Objects.isNull(hmilyTransactionContext) || HmilyActionEnum.TRYING.getCode() != hmilyTransactionContext.getAction()) {
            return null;
        }
        String confirmMethodName = hmily.confirmMethod();
        if (StringUtils.isBlank((CharSequence)confirmMethodName)) {
            confirmMethodName = method.getName();
        }
        if (StringUtils.isBlank((CharSequence)(cancelMethodName = hmily.cancelMethod()))) {
            cancelMethodName = method.getName();
        }
        HmilyInvocation confirmInvocation = new HmilyInvocation(clazz, confirmMethodName, args, arguments);
        HmilyInvocation cancelInvocation = new HmilyInvocation(clazz, cancelMethodName, args, arguments);
        return new HmilyParticipant(hmilyTransactionContext.getTransId(), confirmInvocation, cancelInvocation);
    }

    private void converterParamsClass(Class[] args, Object[] arguments) {
        if (arguments == null || arguments.length < 1) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            args[i] = arguments[i].getClass();
        }
    }
}

