/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.dubbo.interceptor;

import com.alibaba.dubbo.rpc.RpcContext;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.interceptor.HmilyTransactionInterceptor;
import org.dromara.hmily.core.mediator.RpcMediator;
import org.dromara.hmily.core.service.HmilyTransactionAspectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DubboHmilyTransactionInterceptor
implements HmilyTransactionInterceptor {
    private final HmilyTransactionAspectService hmilyTransactionAspectService;

    @Autowired
    public DubboHmilyTransactionInterceptor(HmilyTransactionAspectService hmilyTransactionAspectService) {
        this.hmilyTransactionAspectService = hmilyTransactionAspectService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        HmilyTransactionContext hmilyTransactionContext = RpcMediator.getInstance().acquire(arg_0 -> ((RpcContext)RpcContext.getContext()).getAttachment(arg_0));
        if (Objects.isNull(hmilyTransactionContext)) {
            hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        }
        return this.hmilyTransactionAspectService.invoke(hmilyTransactionContext, pjp);
    }
}

