/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.metrics.facade;

import java.util.Optional;
import java.util.function.Supplier;
import org.dromara.hmily.metrics.api.HistogramMetricsTrackerDelegate;
import org.dromara.hmily.metrics.api.SummaryMetricsTrackerDelegate;
import org.dromara.hmily.metrics.facade.MetricsInitFacade;
import org.dromara.hmily.metrics.facade.handler.MetricsTrackerHandler;
import org.dromara.hmily.metrics.spi.MetricsHandlerFacade;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="metricsTrackerHandlerFacade")
public final class MetricsTrackerHandlerFacade
implements MetricsHandlerFacade {
    private static final Logger log = LoggerFactory.getLogger(MetricsTrackerHandlerFacade.class);

    public void counterIncrement(String metricsLabel, String ... labelValues) {
        if (MetricsInitFacade.getEnabled()) {
            MetricsTrackerHandler.getInstance().counterInc(metricsLabel, labelValues);
        }
    }

    public void gaugeIncrement(String metricsLabel, String ... labelValues) {
        if (MetricsInitFacade.getEnabled()) {
            MetricsTrackerHandler.getInstance().gaugeInc(metricsLabel, labelValues);
        }
    }

    public void gaugeDecrement(String metricsLabel, String ... labelValues) {
        if (MetricsInitFacade.getEnabled()) {
            MetricsTrackerHandler.getInstance().gaugeDec(metricsLabel, labelValues);
        }
    }

    public Supplier<Boolean> histogramStartTimer(String metricsLabel, String ... labelValues) {
        if (!MetricsInitFacade.getEnabled()) {
            return () -> false;
        }
        Optional<HistogramMetricsTrackerDelegate> histogramMetricsTrackerDelegate = MetricsTrackerHandler.getInstance().histogramStartTimer(metricsLabel, labelValues);
        return () -> {
            histogramMetricsTrackerDelegate.ifPresent(this::histogramObserveDuration);
            return true;
        };
    }

    private void histogramObserveDuration(HistogramMetricsTrackerDelegate delegate) {
        if (MetricsInitFacade.getEnabled()) {
            MetricsTrackerHandler.getInstance().histogramObserveDuration(delegate);
        }
    }

    public Supplier<Boolean> summaryStartTimer(String metricsLabel, String ... labelValues) {
        if (!MetricsInitFacade.getEnabled()) {
            return () -> false;
        }
        Optional<SummaryMetricsTrackerDelegate> optionalSummaryMetricsTrackerDelegate = MetricsTrackerHandler.getInstance().summaryStartTimer(metricsLabel, labelValues);
        return () -> {
            optionalSummaryMetricsTrackerDelegate.ifPresent(this::summaryObserveDuration);
            return true;
        };
    }

    private void summaryObserveDuration(SummaryMetricsTrackerDelegate delegate) {
        if (MetricsInitFacade.getEnabled()) {
            MetricsTrackerHandler.getInstance().summaryObserveDuration(delegate);
        }
    }
}

