/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.metrics.facade.handler;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dromara.hmily.metrics.api.CounterMetricsTracker;
import org.dromara.hmily.metrics.api.GaugeMetricsTracker;
import org.dromara.hmily.metrics.api.HistogramMetricsTracker;
import org.dromara.hmily.metrics.api.HistogramMetricsTrackerDelegate;
import org.dromara.hmily.metrics.api.NoneHistogramMetricsTrackerDelegate;
import org.dromara.hmily.metrics.api.NoneSummaryMetricsTrackerDelegate;
import org.dromara.hmily.metrics.api.SummaryMetricsTracker;
import org.dromara.hmily.metrics.api.SummaryMetricsTrackerDelegate;
import org.dromara.hmily.metrics.enums.MetricsTypeEnum;
import org.dromara.hmily.metrics.facade.executor.MetricsThreadPoolExecutor;
import org.dromara.hmily.metrics.spi.MetricsTrackerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsTrackerHandler {
    private static final Logger log = LoggerFactory.getLogger(MetricsTrackerHandler.class);
    private static final int FUTURE_GET_TIME_OUT_MILLISECONDS = 500;
    private static final int QUEUE_SIZE = 5000;
    private MetricsTrackerManager metricsTrackerManager;
    private ExecutorService executorService;
    private volatile boolean async;

    public static MetricsTrackerHandler getInstance() {
        return MetricsTrackerHandlerHolder.INSTANCE;
    }

    public void init(boolean async, int threadCount, MetricsTrackerManager metricsTrackerManager) {
        this.async = async;
        this.metricsTrackerManager = metricsTrackerManager;
        if (async) {
            this.executorService = new MetricsThreadPoolExecutor(threadCount, 5000);
        }
    }

    public void counterInc(String metricsLabel, String ... labelValues) {
        if (this.async) {
            this.executorService.execute(() -> this.handlerCounter(metricsLabel, labelValues));
        } else {
            this.handlerCounter(metricsLabel, labelValues);
        }
    }

    public void gaugeInc(String metricsLabel, String ... labelValues) {
        if (this.async) {
            this.executorService.execute(() -> this.handlerGaugeInc(metricsLabel, labelValues));
        } else {
            this.handlerGaugeInc(metricsLabel, labelValues);
        }
    }

    public void gaugeDec(String metricsLabel, String ... labelValues) {
        if (this.async) {
            this.executorService.execute(() -> this.handlerGaugeDec(metricsLabel, labelValues));
        } else {
            this.handlerGaugeDec(metricsLabel, labelValues);
        }
    }

    public Optional<HistogramMetricsTrackerDelegate> histogramStartTimer(String metricsLabel, String ... labelValues) {
        if (this.async) {
            try {
                return this.executorService.submit(() -> this.handlerHistogramStartTimer(metricsLabel, labelValues)).get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException(String.format("Error while fetching histogram metric with metricsLabel= %s and labelValues=%s", metricsLabel, Arrays.toString(labelValues)), e);
            }
        }
        return this.handlerHistogramStartTimer(metricsLabel, labelValues);
    }

    public void histogramObserveDuration(HistogramMetricsTrackerDelegate delegate) {
        if (this.async) {
            this.executorService.execute(() -> ((HistogramMetricsTrackerDelegate)delegate).observeDuration());
        } else {
            delegate.observeDuration();
        }
    }

    public Optional<SummaryMetricsTrackerDelegate> summaryStartTimer(String metricsLabel, String ... labelValues) {
        if (this.async) {
            try {
                return this.executorService.submit(() -> this.handlerSummaryStartTimer(metricsLabel, labelValues)).get(500L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IllegalStateException(String.format("Error while fetching summary metric with metricsLabel= %s and labelValues=%s", metricsLabel, Arrays.toString(labelValues)), e);
            }
        }
        return this.handlerSummaryStartTimer(metricsLabel, labelValues);
    }

    public void summaryObserveDuration(SummaryMetricsTrackerDelegate delegate) {
        if (this.async) {
            this.executorService.execute(() -> ((SummaryMetricsTrackerDelegate)delegate).observeDuration());
        } else {
            delegate.observeDuration();
        }
    }

    public void close() {
        this.async = false;
        if (null != this.executorService && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    private void handlerCounter(String metricsLabel, String ... labelValues) {
        this.metricsTrackerManager.getMetricsTrackerFactory().create(MetricsTypeEnum.COUNTER.name(), metricsLabel).ifPresent(metricsTracker -> ((CounterMetricsTracker)metricsTracker).inc(1.0, labelValues));
    }

    private void handlerGaugeInc(String metricsLabel, String ... labelValues) {
        this.metricsTrackerManager.getMetricsTrackerFactory().create(MetricsTypeEnum.GAUGE.name(), metricsLabel).ifPresent(metricsTracker -> ((GaugeMetricsTracker)metricsTracker).inc(1.0, labelValues));
    }

    public void handlerGaugeDec(String metricsLabel, String ... labelValues) {
        this.metricsTrackerManager.getMetricsTrackerFactory().create(MetricsTypeEnum.GAUGE.name(), metricsLabel).ifPresent(metricsTracker -> ((GaugeMetricsTracker)metricsTracker).dec(1.0, labelValues));
    }

    private Optional<HistogramMetricsTrackerDelegate> handlerHistogramStartTimer(String metricsLabel, String ... labelValues) {
        Optional metricsTracker = this.metricsTrackerManager.getMetricsTrackerFactory().create(MetricsTypeEnum.HISTOGRAM.name(), metricsLabel);
        return metricsTracker.map(tracker -> Optional.of(((HistogramMetricsTracker)tracker).startTimer(labelValues))).orElseGet(() -> Optional.of(new NoneHistogramMetricsTrackerDelegate()));
    }

    private Optional<SummaryMetricsTrackerDelegate> handlerSummaryStartTimer(String metricsLabel, String ... labelValues) {
        Optional metricsTracker = this.metricsTrackerManager.getMetricsTrackerFactory().create(MetricsTypeEnum.SUMMARY.name(), metricsLabel);
        return metricsTracker.map(tracker -> Optional.of(((SummaryMetricsTracker)tracker).startTimer(labelValues))).orElseGet(() -> Optional.of(new NoneSummaryMetricsTrackerDelegate()));
    }

    public MetricsTrackerManager getMetricsTrackerManager() {
        return this.metricsTrackerManager;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private static class MetricsTrackerHandlerHolder {
        private static final MetricsTrackerHandler INSTANCE = new MetricsTrackerHandler();

        private MetricsTrackerHandlerHolder() {
        }
    }
}

