/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.metrics.facade;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dromara.hmily.config.api.entity.HmilyMetricsConfig;
import org.dromara.hmily.metrics.spi.MetricsBootService;
import org.dromara.hmily.metrics.spi.MetricsRegister;
import org.dromara.hmily.spi.ExtensionLoaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsTrackerFacade
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MetricsTrackerFacade.class);
    private MetricsBootService metricsBootService;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    public void start(HmilyMetricsConfig metricsConfig) {
        if (this.isStarted.compareAndSet(false, true)) {
            this.metricsBootService = (MetricsBootService)ExtensionLoaderFactory.load(MetricsBootService.class, (String)metricsConfig.getMetricsName());
            Preconditions.checkNotNull((Object)this.metricsBootService, (String)"Can not find metrics tracker manager with metrics name : %s in metrics configuration.", (Object)metricsConfig.getMetricsName());
            this.metricsBootService.start(metricsConfig, (MetricsRegister)ExtensionLoaderFactory.load(MetricsRegister.class, (String)metricsConfig.getMetricsName()));
        } else {
            log.info("metrics tracker has started !");
        }
    }

    @Override
    public void close() {
        this.isStarted.compareAndSet(true, false);
        if (null != this.metricsBootService) {
            this.metricsBootService.stop();
        }
    }
}

