/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.metrics.prometheus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.dromara.hmily.metrics.api.MetricsTracker;
import org.dromara.hmily.metrics.api.MetricsTrackerFactory;
import org.dromara.hmily.metrics.prometheus.impl.counter.TransactionStatusCounterMetricsTracker;
import org.dromara.hmily.metrics.prometheus.impl.counter.TransactionTotalCounterMetricsTracker;
import org.dromara.hmily.metrics.prometheus.impl.histogram.TransactionLatencyHistogramMetricsTracker;
import org.dromara.hmily.metrics.prometheus.impl.summary.TransactionLatencySummaryMetricsTracker;

public final class PrometheusMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Collection<MetricsTracker> REGISTER = new ArrayList<MetricsTracker>();

    public Optional<MetricsTracker> create(String metricsType, String metricsLabel) {
        return REGISTER.stream().filter(each -> each.metricsLabel().equals(metricsLabel) && each.metricsType().equals(metricsType)).findFirst();
    }

    static {
        REGISTER.add((MetricsTracker)new TransactionTotalCounterMetricsTracker());
        REGISTER.add((MetricsTracker)new TransactionStatusCounterMetricsTracker());
        REGISTER.add((MetricsTracker)new TransactionLatencyHistogramMetricsTracker());
        REGISTER.add((MetricsTracker)new TransactionLatencySummaryMetricsTracker());
    }
}

