/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.motan.loadbalance;

import com.google.common.collect.Maps;
import com.weibo.api.motan.cluster.loadbalance.RandomLoadBalance;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;

@SpiMeta(name="hmily")
@Activation(key={"service", "referer"})
public class MotanHmilyLoadBalance<T>
extends RandomLoadBalance<T> {
    private static final Map<String, URL> URL_MAP = Maps.newConcurrentMap();

    protected Referer<T> doSelect(Request request) {
        Referer referer = super.doSelect(request);
        List refererList = this.getReferers();
        HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        if (Objects.isNull(hmilyTransactionContext)) {
            return referer;
        }
        String transId = hmilyTransactionContext.getTransId();
        if (hmilyTransactionContext.getAction() == HmilyActionEnum.TRYING.getCode()) {
            URL_MAP.put(transId, referer.getUrl());
            return referer;
        }
        URL orlUrl = URL_MAP.get(transId);
        URL_MAP.remove(transId);
        if (Objects.nonNull(orlUrl)) {
            for (Referer inv : refererList) {
                if (!Objects.equals(inv.getUrl(), orlUrl)) continue;
                return inv;
            }
        }
        return referer;
    }

    protected void doSelectToHolder(Request request, List<Referer<T>> refersHolder) {
        super.doSelectToHolder(request, refersHolder);
    }
}

