/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.motan.interceptor;

import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.RpcContext;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.utils.GsonUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.interceptor.HmilyTransactionInterceptor;
import org.dromara.hmily.core.service.HmilyTransactionAspectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MotanHmilyTransactionInterceptor
implements HmilyTransactionInterceptor {
    private final HmilyTransactionAspectService hmilyTransactionAspectService;

    @Autowired
    public MotanHmilyTransactionInterceptor(HmilyTransactionAspectService hmilyTransactionAspectService) {
        this.hmilyTransactionAspectService = hmilyTransactionAspectService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        HmilyTransactionContext hmilyTransactionContext = null;
        Request request = RpcContext.getContext().getRequest();
        if (Objects.nonNull(request)) {
            Map attachments = request.getAttachments();
            if (attachments != null && !attachments.isEmpty()) {
                String context = (String)attachments.get("HMILY_TRANSACTION_CONTEXT");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{context})) {
                    hmilyTransactionContext = (HmilyTransactionContext)GsonUtils.getInstance().fromJson(context, HmilyTransactionContext.class);
                    request.getAttachments().remove("HMILY_TRANSACTION_CONTEXT");
                } else {
                    hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
                }
            }
        } else {
            hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        }
        return this.hmilyTransactionAspectService.invoke(hmilyTransactionContext, pjp);
    }
}

