/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.motan.interceptor;

import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.RpcContext;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.interceptor.HmilyTransactionInterceptor;
import org.dromara.hmily.core.mediator.RpcMediator;
import org.dromara.hmily.core.service.HmilyTransactionAspectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MotanHmilyTransactionInterceptor
implements HmilyTransactionInterceptor {
    private final HmilyTransactionAspectService hmilyTransactionAspectService;

    @Autowired
    public MotanHmilyTransactionInterceptor(HmilyTransactionAspectService hmilyTransactionAspectService) {
        this.hmilyTransactionAspectService = hmilyTransactionAspectService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        HmilyTransactionContext hmilyTransactionContext = RpcMediator.getInstance().acquire(key -> {
            Map attachments;
            Request request = RpcContext.getContext().getRequest();
            if (Objects.nonNull(request) && (attachments = request.getAttachments()) != null && !attachments.isEmpty()) {
                return (String)attachments.get(key);
            }
            return "";
        });
        if (Objects.isNull(hmilyTransactionContext)) {
            hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        }
        return this.hmilyTransactionAspectService.invoke(hmilyTransactionContext, pjp);
    }
}

