/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.motan.filter;

import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.annotation.PatternEnum;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyInvocation;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.helper.SpringBeanUtils;
import org.dromara.hmily.core.mediator.RpcMediator;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;

@SpiMeta(name="motanHmilyTransactionFilter")
@Activation(key={"referer"})
public class MotanHmilyTransactionFilter
implements Filter {
    public Response filter(Caller<?> caller, Request request) {
        String interfaceName = request.getInterfaceName();
        String methodName = request.getMethodName();
        Object[] arguments = request.getArguments();
        Class[] args = null;
        Method method = null;
        Hmily hmily = null;
        Class clazz = null;
        try {
            clazz = ReflectUtil.forName((String)interfaceName);
            Method[] methods = clazz.getMethods();
            args = Stream.of(methods).filter(m -> m.getName().equals(methodName)).findFirst().map(Method::getParameterTypes).get();
            method = clazz.getMethod(methodName, args);
            hmily = method.getAnnotation(Hmily.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Objects.nonNull(hmily)) {
            try {
                HmilyTransactionExecutor hmilyTransactionExecutor = (HmilyTransactionExecutor)SpringBeanUtils.getInstance().getBean(HmilyTransactionExecutor.class);
                HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
                if (Objects.nonNull(hmilyTransactionContext)) {
                    RpcMediator.getInstance().transmit((arg_0, arg_1) -> ((Request)request).setAttachment(arg_0, arg_1), hmilyTransactionContext);
                }
                Response response = caller.call(request);
                HmilyParticipant hmilyParticipant = this.buildParticipant(hmilyTransactionContext, hmily, method, clazz, arguments, args);
                if (hmilyTransactionContext.getRole() == HmilyRoleEnum.INLINE.getCode()) {
                    hmilyTransactionExecutor.registerByNested(hmilyTransactionContext.getTransId(), hmilyParticipant);
                } else {
                    hmilyTransactionExecutor.enlistParticipant(hmilyParticipant);
                }
                return response;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return caller.call(request);
    }

    private HmilyParticipant buildParticipant(HmilyTransactionContext hmilyTransactionContext, Hmily hmily, Method method, Class clazz, Object[] arguments, Class ... args) throws HmilyRuntimeException {
        String cancelMethodName;
        if (Objects.isNull(hmilyTransactionContext) || HmilyActionEnum.TRYING.getCode() != hmilyTransactionContext.getAction()) {
            return null;
        }
        String confirmMethodName = hmily.confirmMethod();
        if (StringUtils.isBlank((CharSequence)confirmMethodName)) {
            confirmMethodName = method.getName();
        }
        if (StringUtils.isBlank((CharSequence)(cancelMethodName = hmily.cancelMethod()))) {
            cancelMethodName = method.getName();
        }
        PatternEnum pattern = hmily.pattern();
        ((HmilyTransactionExecutor)SpringBeanUtils.getInstance().getBean(HmilyTransactionExecutor.class)).getCurrentTransaction().setPattern(pattern.getCode());
        HmilyInvocation confirmInvocation = new HmilyInvocation(clazz, confirmMethodName, args, arguments);
        HmilyInvocation cancelInvocation = new HmilyInvocation(clazz, cancelMethodName, args, arguments);
        return new HmilyParticipant(hmilyTransactionContext.getTransId(), confirmInvocation, cancelInvocation);
    }
}

