/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.motan.loadbalance;

import com.google.common.collect.Maps;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;

public class HmilyLoadBalanceUtils {
    private static final Map<String, URL> URL_MAP = Maps.newConcurrentMap();

    public static <T> Referer<T> doSelect(Referer<T> defaultReferer, List<Referer<T>> refererList) {
        HmilyTransactionContext hmilyTransactionContext = HmilyContextHolder.get();
        if (Objects.isNull(hmilyTransactionContext)) {
            return defaultReferer;
        }
        String key = defaultReferer.getInterface().getName();
        if (hmilyTransactionContext.getAction() == HmilyActionEnum.TRYING.getCode()) {
            URL_MAP.put(key, defaultReferer.getUrl());
            return defaultReferer;
        }
        URL orlUrl = URL_MAP.get(key);
        URL_MAP.remove(key);
        if (Objects.nonNull(orlUrl)) {
            for (Referer<T> inv : refererList) {
                if (!Objects.equals(inv.getUrl(), orlUrl)) continue;
                return inv;
            }
        }
        return defaultReferer;
    }
}

