/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.repository.etcd;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.config.api.ConfigEnv;
import org.dromara.hmily.config.api.entity.HmilyEtcdConfig;
import org.dromara.hmily.repository.spi.HmilyRepository;
import org.dromara.hmily.repository.spi.HmilyRepositoryNode;
import org.dromara.hmily.repository.spi.entity.HmilyLock;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.repository.spi.entity.HmilyParticipantUndo;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.dromara.hmily.repository.spi.exception.HmilyRepositoryException;
import org.dromara.hmily.serializer.spi.HmilySerializer;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="etcd")
public class EtcdRepository
implements HmilyRepository {
    private static final Logger log = LoggerFactory.getLogger(EtcdRepository.class);
    private Client client;
    private HmilySerializer hmilySerializer;
    private HmilyRepositoryNode node;
    private String appName;

    public void init(String appName) {
        this.appName = appName;
        this.node = new HmilyRepositoryNode(appName);
        HmilyEtcdConfig etcdConfig = (HmilyEtcdConfig)ConfigEnv.getInstance().getConfig(HmilyEtcdConfig.class);
        this.client = Client.builder().endpoints((Collection)Util.toURIs((Collection)Splitter.on((String)",").trimResults().splitToList((CharSequence)etcdConfig.getHost()))).namespace(ByteSequence.from((String)etcdConfig.getRootPath(), (Charset)Charsets.UTF_8)).build();
    }

    public void setSerializer(HmilySerializer hmilySerializer) {
        this.hmilySerializer = hmilySerializer;
    }

    public int createHmilyTransaction(HmilyTransaction hmilyTransaction) throws HmilyRepositoryException {
        String path = this.node.getHmilyTransactionRealPath(hmilyTransaction.getTransId());
        try {
            boolean exist = this.isExist(path);
            hmilyTransaction.setAppName(this.appName);
            if (!exist) {
                hmilyTransaction.setRetry(Integer.valueOf(0));
                hmilyTransaction.setVersion(Integer.valueOf(0));
                hmilyTransaction.setCreateTime(new Date());
            } else {
                hmilyTransaction.setVersion(Integer.valueOf(hmilyTransaction.getVersion() + 1));
            }
            hmilyTransaction.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyTransaction)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HmilyException((Throwable)e);
        }
    }

    public int updateRetryByLock(HmilyTransaction hmilyTransaction) {
        int currentVersion = hmilyTransaction.getVersion();
        String path = this.node.getHmilyTransactionRealPath(hmilyTransaction.getTransId());
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (null == keyValue) {
                log.warn("path {} is not exists.", (Object)path);
                return 0;
            }
            if ((long)currentVersion != keyValue.getVersion()) {
                log.warn("current transaction data version different from etcd server. current version: {}, server data version:  {}", (Object)currentVersion, (Object)keyValue.getVersion());
            }
            hmilyTransaction.setVersion(Integer.valueOf(currentVersion + 1));
            hmilyTransaction.setRetry(Integer.valueOf(hmilyTransaction.getRetry() + 1));
            hmilyTransaction.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyTransaction)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("updateRetryByLock occur a exception", (Throwable)e);
            return 0;
        }
    }

    private KeyValue getKeyValue(String path) throws InterruptedException, ExecutionException {
        List keyValues = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).get()).getKvs();
        return keyValues.isEmpty() ? null : (KeyValue)keyValues.iterator().next();
    }

    private boolean isExist(String path) throws InterruptedException, ExecutionException {
        return ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).get()).getCount() > 0L;
    }

    public HmilyTransaction findByTransId(Long transId) {
        String path = this.node.getHmilyTransactionRealPath(transId);
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (keyValue == null) {
                return null;
            }
            return (HmilyTransaction)this.hmilySerializer.deSerialize(keyValue.getValue().getBytes(), HmilyTransaction.class);
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("findByTransId occur a exception", (Throwable)e);
            return null;
        }
    }

    public List<HmilyTransaction> listLimitByDelay(Date date, int limit) {
        String path = this.node.getHmilyTransactionRootPath();
        return this.listByFilter(path, HmilyTransaction.class, (hmilyTransaction, params) -> {
            Date dateParam = (Date)params[0];
            int limitParam = (Integer)params[1];
            boolean filterResult = dateParam.after(hmilyTransaction.getUpdateTime()) && this.appName.equals(hmilyTransaction.getAppName()) && limitParam-- > 0;
            params[1] = limitParam;
            return filterResult;
        }, date, limit);
    }

    public int updateHmilyTransactionStatus(Long transId, Integer status) throws HmilyRepositoryException {
        String path = this.node.getHmilyTransactionRealPath(transId);
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (null == keyValue) {
                return 0;
            }
            HmilyTransaction hmilyTransaction = (HmilyTransaction)this.hmilySerializer.deSerialize(keyValue.getValue().getBytes(), HmilyTransaction.class);
            hmilyTransaction.setStatus(status.intValue());
            hmilyTransaction.setVersion(Integer.valueOf(hmilyTransaction.getVersion() + 1));
            hmilyTransaction.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyTransaction)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("updateHmilyTransactionStatus occur a exception", (Throwable)e);
            return 0;
        }
    }

    public int removeHmilyTransaction(Long transId) {
        String path = this.node.getHmilyTransactionRealPath(transId);
        try {
            this.client.getKVClient().delete(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).get();
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("removeHmilyTransaction occur a exception", (Throwable)e);
            return 0;
        }
    }

    public int removeHmilyTransactionByDate(Date date) {
        String path = this.node.getHmilyTransactionRootPath();
        return this.removeByFilter(path, HmilyTransaction.class, (hmilyTransaction, params) -> {
            Date dateParam = (Date)params[0];
            return dateParam.after(hmilyTransaction.getUpdateTime()) && hmilyTransaction.getStatus() == HmilyActionEnum.DELETE.getCode();
        }, date);
    }

    public int createHmilyParticipant(HmilyParticipant hmilyParticipant) throws HmilyRepositoryException {
        try {
            String path = this.node.getHmilyParticipantRealPath(hmilyParticipant.getParticipantId());
            KeyValue keyValue = this.getKeyValue(path);
            hmilyParticipant.setAppName(this.appName);
            if (null == keyValue) {
                hmilyParticipant.setRetry(0);
                hmilyParticipant.setVersion(Integer.valueOf(0));
                hmilyParticipant.setCreateTime(new Date());
            } else {
                hmilyParticipant.setVersion(Integer.valueOf(hmilyParticipant.getVersion() + 1));
            }
            hmilyParticipant.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyParticipant)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HmilyException((Throwable)e);
        }
    }

    public List<HmilyParticipant> findHmilyParticipant(Long participantId) {
        String path = this.node.getHmilyParticipantRootPath();
        return this.listByFilter(path, HmilyParticipant.class, (hmilyParticipant, params) -> {
            Long participantIdParam = (Long)params[0];
            return participantIdParam.compareTo(hmilyParticipant.getParticipantId()) == 0 || hmilyParticipant.getParticipantRefId() != null && participantIdParam.compareTo(hmilyParticipant.getParticipantRefId()) == 0;
        }, participantId);
    }

    public List<HmilyParticipant> listHmilyParticipant(Date date, String transType, int limit) {
        String path = this.node.getHmilyParticipantRootPath();
        return this.listByFilter(path, HmilyParticipant.class, (hmilyParticipant, params) -> {
            Date dateParam = (Date)params[0];
            String transTypeParam = (String)params[1];
            int limitParam = (Integer)params[2];
            boolean filterResult = dateParam.after(hmilyParticipant.getUpdateTime()) && this.appName.equals(hmilyParticipant.getAppName()) && transTypeParam.equals(hmilyParticipant.getTransType()) && hmilyParticipant.getStatus().compareTo(HmilyActionEnum.DELETE.getCode()) != 0 && hmilyParticipant.getStatus().compareTo(HmilyActionEnum.DEATH.getCode()) != 0 && limitParam-- > 0;
            params[2] = limitParam;
            return filterResult;
        }, date, transType, limit);
    }

    public List<HmilyParticipant> listHmilyParticipantByTransId(Long transId) {
        String path = this.node.getHmilyParticipantRootPath();
        return this.listByFilter(path, HmilyParticipant.class, (hmilyParticipant, params) -> transId.compareTo(hmilyParticipant.getTransId()) == 0, transId);
    }

    public boolean existHmilyParticipantByTransId(Long transId) {
        String path = this.node.getHmilyParticipantRootPath();
        return this.existByFilter(path, HmilyParticipant.class, (hmilyParticipant, params) -> {
            Long transIdParam = (Long)params[0];
            return transIdParam.compareTo(hmilyParticipant.getTransId()) == 0;
        }, transId);
    }

    public int updateHmilyParticipantStatus(Long participantId, Integer status) throws HmilyRepositoryException {
        String path = this.node.getHmilyParticipantRealPath(participantId);
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (null == keyValue) {
                return 0;
            }
            HmilyParticipant hmilyParticipant = (HmilyParticipant)this.hmilySerializer.deSerialize(keyValue.getValue().getBytes(), HmilyParticipant.class);
            hmilyParticipant.setStatus(status);
            hmilyParticipant.setVersion(Integer.valueOf(hmilyParticipant.getVersion() + 1));
            hmilyParticipant.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyParticipant)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("updateHmilyParticipantStatus occur a exception", (Throwable)e);
            return 0;
        }
    }

    public int removeHmilyParticipant(Long participantId) {
        String path = this.node.getHmilyParticipantRealPath(participantId);
        try {
            this.client.getKVClient().delete(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).get();
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("removeHmilyParticipant occur a exception", (Throwable)e);
            return 0;
        }
    }

    public int removeHmilyParticipantByDate(Date date) {
        String path = this.node.getHmilyParticipantRootPath();
        return this.removeByFilter(path, HmilyParticipant.class, (hmilyParticipant, params) -> {
            Date dateParam = (Date)params[0];
            return dateParam.after(hmilyParticipant.getUpdateTime()) && hmilyParticipant.getStatus().compareTo(HmilyActionEnum.DELETE.getCode()) == 0;
        }, date);
    }

    public boolean lockHmilyParticipant(HmilyParticipant hmilyParticipant) {
        int currentVersion = hmilyParticipant.getVersion();
        String path = this.node.getHmilyParticipantRealPath(hmilyParticipant.getParticipantId());
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (null == keyValue) {
                log.warn("path {} is not exists.", (Object)path);
                return false;
            }
            if ((long)currentVersion != keyValue.getVersion()) {
                log.warn("current transaction participant data version different from etcd server. current version: {}, server data version:  {}", (Object)currentVersion, (Object)keyValue.getVersion());
            }
            hmilyParticipant.setVersion(Integer.valueOf(currentVersion + 1));
            hmilyParticipant.setRetry(hmilyParticipant.getRetry() + 1);
            hmilyParticipant.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyParticipant)));
            return true;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("updateRetryByLock occur a exception", (Throwable)e);
            return false;
        }
    }

    public int createHmilyParticipantUndo(HmilyParticipantUndo hmilyParticipantUndo) {
        String path = this.node.getHmilyParticipantUndoRealPath(hmilyParticipantUndo.getUndoId());
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (null == keyValue) {
                hmilyParticipantUndo.setCreateTime(new Date());
            }
            hmilyParticipantUndo.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyParticipantUndo)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HmilyException((Throwable)e);
        }
    }

    public List<HmilyParticipantUndo> findHmilyParticipantUndoByParticipantId(Long participantId) {
        String path = this.node.getHmilyParticipantUndoRootPath();
        return this.listByFilter(path, HmilyParticipantUndo.class, (undo, params) -> {
            Long participantIdParam = (Long)params[0];
            return participantIdParam.compareTo(undo.getParticipantId()) == 0;
        }, participantId);
    }

    public int removeHmilyParticipantUndo(Long undoId) {
        String path = this.node.getHmilyParticipantUndoRealPath(undoId);
        try {
            this.client.getKVClient().delete(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).get();
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("removeHmilyParticipantUndo occur a exception", (Throwable)e);
            return 0;
        }
    }

    public int removeHmilyParticipantUndoByDate(Date date) {
        String path = this.node.getHmilyParticipantUndoRootPath();
        return this.removeByFilter(path, HmilyParticipantUndo.class, (undo, params) -> {
            Date dateParam = (Date)params[0];
            return dateParam.after(undo.getUpdateTime()) && undo.getStatus().compareTo(HmilyActionEnum.DELETE.getCode()) == 0;
        }, date);
    }

    public int updateHmilyParticipantUndoStatus(Long undoId, Integer status) {
        String path = this.node.getHmilyParticipantUndoRealPath(undoId);
        try {
            KeyValue keyValue = this.getKeyValue(path);
            if (null == keyValue) {
                return 0;
            }
            HmilyParticipantUndo hmilyParticipantUndo = (HmilyParticipantUndo)this.hmilySerializer.deSerialize(keyValue.getValue().getBytes(), HmilyParticipantUndo.class);
            hmilyParticipantUndo.setStatus(status);
            hmilyParticipantUndo.setUpdateTime(new Date());
            this.client.getKVClient().put(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), ByteSequence.from((byte[])this.hmilySerializer.serialize((Object)hmilyParticipantUndo)));
            return 1;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("updateHmilyParticipantStatus occur a exception", (Throwable)e);
            return 0;
        }
    }

    public int writeHmilyLocks(Collection<HmilyLock> locks) {
        return 0;
    }

    public int releaseHmilyLocks(Collection<HmilyLock> locks) {
        return 0;
    }

    public Optional<HmilyLock> findHmilyLockById(String lockId) {
        return Optional.empty();
    }

    private <T> List<T> listByFilter(String path, Class<T> deserializeClass, Filter<T> filter, Object ... params) {
        try {
            GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).build();
            List children = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), option).get()).getKvs();
            if (CollectionUtils.isEmpty((Collection)children)) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (KeyValue child : children) {
                Object t = this.hmilySerializer.deSerialize(child.getValue().getBytes(), deserializeClass);
                if (!filter.filter(t, params)) continue;
                result.add(t);
            }
            return result;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("listByFilter occur a exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private <T> boolean existByFilter(String path, Class<T> deserializeClass, Filter<T> filter, Object ... params) {
        try {
            GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).build();
            List children = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), option).get()).getKvs();
            if (CollectionUtils.isEmpty((Collection)children)) {
                return false;
            }
            for (KeyValue child : children) {
                Object t = this.hmilySerializer.deSerialize(child.getValue().getBytes(), deserializeClass);
                if (!filter.filter(t, params)) continue;
                return true;
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("existByFilter occur a exception", (Throwable)e);
        }
        return false;
    }

    private <T> int removeByFilter(String path, Class<T> deserializeClass, Filter<T> filter, Object ... params) {
        try {
            GetOption option = GetOption.newBuilder().withPrefix(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8)).build();
            List children = ((GetResponse)this.client.getKVClient().get(ByteSequence.from((String)path, (Charset)StandardCharsets.UTF_8), option).get()).getKvs();
            if (CollectionUtils.isEmpty((Collection)children)) {
                return 0;
            }
            int count = 0;
            for (KeyValue child : children) {
                Object t = this.hmilySerializer.deSerialize(child.getValue().getBytes(), deserializeClass);
                if (!filter.filter(t, params)) continue;
                this.client.getKVClient().delete(child.getKey());
                ++count;
            }
            return count;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("removeByFilter occur a exception", (Throwable)e);
            return 0;
        }
    }

    static interface Filter<T> {
        public boolean filter(T var1, Object ... var2);
    }
}

