/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.feign;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyInvocation;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.helper.SpringBeanUtils;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;

public class HmilyFeignHandler
implements InvocationHandler {
    private InvocationHandler delegate;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        Hmily hmily = method.getAnnotation(Hmily.class);
        if (Objects.isNull(hmily)) {
            return this.delegate.invoke(proxy, method, args);
        }
        try {
            HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
            if (Objects.nonNull(hmilyTransactionContext) && hmilyTransactionContext.getRole() == HmilyRoleEnum.LOCAL.getCode()) {
                hmilyTransactionContext.setRole(HmilyRoleEnum.INLINE.getCode());
            }
            HmilyTransactionExecutor hmilyTransactionExecutor = (HmilyTransactionExecutor)SpringBeanUtils.getInstance().getBean(HmilyTransactionExecutor.class);
            Object invoke = this.delegate.invoke(proxy, method, args);
            HmilyParticipant hmilyParticipant = this.buildParticipant(hmily, method, args, hmilyTransactionContext);
            if (hmilyTransactionContext.getRole() == HmilyRoleEnum.INLINE.getCode()) {
                hmilyTransactionExecutor.registerByNested(hmilyTransactionContext.getTransId(), hmilyParticipant);
            } else {
                hmilyTransactionExecutor.enlistParticipant(hmilyParticipant);
            }
            return invoke;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw throwable;
        }
    }

    private HmilyParticipant buildParticipant(Hmily hmily, Method method, Object[] args, HmilyTransactionContext hmilyTransactionContext) {
        String cancelMethodName;
        if (Objects.isNull(hmilyTransactionContext) || HmilyActionEnum.TRYING.getCode() != hmilyTransactionContext.getAction()) {
            return null;
        }
        String confirmMethodName = hmily.confirmMethod();
        if (StringUtils.isBlank((CharSequence)confirmMethodName)) {
            confirmMethodName = method.getName();
        }
        if (StringUtils.isBlank((CharSequence)(cancelMethodName = hmily.cancelMethod()))) {
            cancelMethodName = method.getName();
        }
        Class<?> declaringClass = method.getDeclaringClass();
        HmilyInvocation confirmInvocation = new HmilyInvocation(declaringClass, confirmMethodName, (Class[])method.getParameterTypes(), args);
        HmilyInvocation cancelInvocation = new HmilyInvocation(declaringClass, cancelMethodName, (Class[])method.getParameterTypes(), args);
        return new HmilyParticipant(hmilyTransactionContext.getTransId(), confirmInvocation, cancelInvocation);
    }

    void setDelegate(InvocationHandler delegate) {
        this.delegate = delegate;
    }
}

