/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.interceptor;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.utils.GsonUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.interceptor.HmilyTransactionInterceptor;
import org.dromara.hmily.core.service.HmilyTransactionAspectService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SpringCloudHmilyTransactionInterceptor
implements HmilyTransactionInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudHmilyTransactionInterceptor.class);
    private final HmilyTransactionAspectService hmilyTransactionAspectService;

    @Autowired
    public SpringCloudHmilyTransactionInterceptor(HmilyTransactionAspectService hmilyTransactionAspectService) {
        this.hmilyTransactionAspectService = hmilyTransactionAspectService;
    }

    public Object interceptor(ProceedingJoinPoint pjp) throws Throwable {
        HmilyTransactionContext hmilyTransactionContext;
        String context;
        RequestAttributes requestAttributes = null;
        try {
            requestAttributes = RequestContextHolder.currentRequestAttributes();
        }
        catch (Throwable ex) {
            LogUtil.warn((Logger)LOGGER, () -> "can not acquire request info:" + ex.getLocalizedMessage());
        }
        HttpServletRequest request = requestAttributes == null ? null : ((ServletRequestAttributes)requestAttributes).getRequest();
        String string = context = request == null ? null : request.getHeader("HMILY_TRANSACTION_CONTEXT");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{context})) {
            hmilyTransactionContext = (HmilyTransactionContext)GsonUtils.getInstance().fromJson(context, HmilyTransactionContext.class);
        } else {
            hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
            if (Objects.nonNull(hmilyTransactionContext)) {
                hmilyTransactionContext.setRole(HmilyRoleEnum.SPRING_CLOUD.getCode());
            }
        }
        return this.hmilyTransactionAspectService.invoke(hmilyTransactionContext, pjp);
    }
}

