/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.loadbalancer;

import com.google.common.collect.Maps;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;

public class HmilyZoneAwareLoadBalancer
extends ZoneAwareLoadBalancer<Server> {
    private static final Map<String, Server> SERVER_MAP = Maps.newConcurrentMap();

    public HmilyZoneAwareLoadBalancer(IClientConfig clientConfig, IRule rule, IPing ping, ServerList<Server> serverList, ServerListFilter<Server> filter, ServerListUpdater serverListUpdater) {
        super(clientConfig, rule, ping, serverList, filter, serverListUpdater);
    }

    public Server chooseServer(Object key) {
        List serverList = super.getServerListImpl().getUpdatedListOfServers();
        serverList = super.getFilter().getFilteredListOfServers(serverList);
        if (null == serverList || serverList.isEmpty() || serverList.size() == 1) {
            return super.chooseServer(key);
        }
        Server server = super.chooseServer(key);
        HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        if (Objects.isNull(hmilyTransactionContext)) {
            return server;
        }
        String transId = hmilyTransactionContext.getTransId();
        if (hmilyTransactionContext.getAction() == HmilyActionEnum.TRYING.getCode()) {
            SERVER_MAP.put(transId, server);
            return server;
        }
        Server oldServer = SERVER_MAP.get(transId);
        SERVER_MAP.remove(transId);
        if (Objects.nonNull(oldServer)) {
            for (Server s : serverList) {
                if (!Objects.equals(s, oldServer)) continue;
                return oldServer;
            }
        }
        return server;
    }
}

