/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.loadbalancer;

import com.google.common.collect.Maps;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;

public class HmilyZoneAwareLoadBalancer
extends ZoneAvoidanceRule {
    private static final Map<String, Server> SERVER_MAP = Maps.newConcurrentMap();

    public Server choose(Object key) {
        List serverList = this.getLoadBalancer().getAllServers();
        if (null == serverList || serverList.isEmpty() || serverList.size() == 1) {
            return super.choose(key);
        }
        Server server = super.choose(key);
        HmilyTransactionContext hmilyTransactionContext = HmilyTransactionContextLocal.getInstance().get();
        if (Objects.isNull(hmilyTransactionContext)) {
            return server;
        }
        String transId = hmilyTransactionContext.getTransId();
        if (hmilyTransactionContext.getAction() == HmilyActionEnum.TRYING.getCode()) {
            SERVER_MAP.put(transId, server);
            return server;
        }
        Server oldServer = SERVER_MAP.get(transId);
        SERVER_MAP.remove(transId);
        if (Objects.nonNull(oldServer)) {
            for (Server s : serverList) {
                if (!Objects.equals(s, oldServer)) continue;
                return oldServer;
            }
        }
        return server;
    }
}

