/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.feign;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.springcloud.feign.HmilyFeignHandler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class HmilyFeignBeanPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        if (!Proxy.isProxyClass(bean.getClass())) {
            return bean;
        }
        InvocationHandler handler = Proxy.getInvocationHandler(bean);
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) {
            Hmily hmily = (Hmily)AnnotationUtils.findAnnotation((Method)method, Hmily.class);
            if (!Objects.nonNull(hmily)) continue;
            HmilyFeignHandler hmilyFeignHandler = new HmilyFeignHandler();
            hmilyFeignHandler.setDelegate(handler);
            Class<?> clazz = bean.getClass();
            Class<?>[] interfaces = clazz.getInterfaces();
            ClassLoader loader = clazz.getClassLoader();
            return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)hmilyFeignHandler);
        }
        return bean;
    }
}

