/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.parameter;

import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.mediator.RpcMediator;
import org.dromara.hmily.core.mediator.RpcParameterLoader;
import org.dromara.hmily.spi.HmilySPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HmilySPI(value="springCloud")
public class SpringCloudParameterLoader
implements RpcParameterLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCloudParameterLoader.class);

    public HmilyTransactionContext load() {
        HmilyTransactionContext hmilyTransactionContext = null;
        try {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            hmilyTransactionContext = RpcMediator.getInstance().acquire(key -> ((ServletRequestAttributes)requestAttributes).getRequest().getHeader(key));
        }
        catch (IllegalStateException ex) {
            LogUtil.warn((Logger)LOGGER, () -> "can not acquire request info:" + ex.getLocalizedMessage());
        }
        return hmilyTransactionContext;
    }
}

