/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.springcloud.feign;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.repository.spi.entity.HmilyInvocation;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmilyFeignHandler
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmilyFeignHandler.class);
    private InvocationHandler delegate;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        HmilyTransactionContext context = HmilyContextHolder.get();
        if (Objects.isNull(context)) {
            return this.delegate.invoke(proxy, method, args);
        }
        Hmily hmily = method.getAnnotation(Hmily.class);
        if (Objects.isNull(hmily)) {
            return this.delegate.invoke(proxy, method, args);
        }
        try {
            Long participantId = context.getParticipantId();
            HmilyParticipant hmilyParticipant = this.buildParticipant(method, args, context);
            Optional.ofNullable(hmilyParticipant).ifPresent(participant -> context.setParticipantId(participant.getParticipantId()));
            if (context.getRole() == HmilyRoleEnum.PARTICIPANT.getCode()) {
                context.setParticipantRefId(participantId);
            }
            Object invoke = this.delegate.invoke(proxy, method, args);
            if (context.getRole() == HmilyRoleEnum.PARTICIPANT.getCode()) {
                HmilyTransactionHolder.getInstance().registerParticipantByNested(participantId, hmilyParticipant);
            } else {
                HmilyTransactionHolder.getInstance().registerStarterParticipant(hmilyParticipant);
            }
            return invoke;
        }
        catch (Throwable e) {
            LOGGER.error("HmilyFeignHandler invoker exception :", e);
            throw e;
        }
    }

    private HmilyParticipant buildParticipant(Method method, Object[] args, HmilyTransactionContext context) {
        if (HmilyActionEnum.TRYING.getCode() != context.getAction()) {
            return null;
        }
        HmilyParticipant hmilyParticipant = new HmilyParticipant();
        hmilyParticipant.setParticipantId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        hmilyParticipant.setTransId(context.getTransId());
        hmilyParticipant.setTransType(context.getTransType());
        Class<?> declaringClass = method.getDeclaringClass();
        HmilyInvocation hmilyInvocation = new HmilyInvocation(declaringClass, method.getName(), (Class[])method.getParameterTypes(), args);
        hmilyParticipant.setConfirmHmilyInvocation(hmilyInvocation);
        hmilyParticipant.setCancelHmilyInvocation(hmilyInvocation);
        return hmilyParticipant;
    }

    void setDelegate(InvocationHandler delegate) {
        this.delegate = delegate;
    }
}

