/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.dromara.hmily.core.repository.HmilyRepositoryFacade;
import org.dromara.hmily.repository.spi.entity.HmilyLock;

public final class HmilyLockCacheManager {
    private static final HmilyLockCacheManager INSTANCE = new HmilyLockCacheManager();
    private static final int MAX_COUNT = 1000000;
    private final LoadingCache<String, Optional<HmilyLock>> loadingCache = CacheBuilder.newBuilder().maximumWeight(1000000L).weigher((e1, e2) -> this.getSize()).build((CacheLoader)new CacheLoader<String, Optional<HmilyLock>>(){

        public Optional<HmilyLock> load(String key) {
            return HmilyRepositoryFacade.getInstance().findHmilyLockById(key);
        }
    });

    private HmilyLockCacheManager() {
    }

    public static HmilyLockCacheManager getInstance() {
        return INSTANCE;
    }

    public void cacheHmilyLock(String lockId, HmilyLock hmilyLock) {
        this.loadingCache.put((Object)lockId, Optional.of(hmilyLock));
    }

    public Optional<HmilyLock> get(String lockId) {
        try {
            return (Optional)this.loadingCache.get((Object)lockId);
        }
        catch (ExecutionException ex) {
            return Optional.empty();
        }
    }

    public void removeByKey(String lockId) {
        if (Objects.nonNull(lockId)) {
            this.loadingCache.invalidate((Object)lockId);
        }
    }

    private int getSize() {
        return (int)this.loadingCache.size();
    }
}

