/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.core.repository.HmilyRepositoryFacade;
import org.dromara.hmily.repository.spi.entity.HmilyParticipantUndo;

public final class HmilyParticipantUndoCacheManager {
    private static final HmilyParticipantUndoCacheManager INSTANCE = new HmilyParticipantUndoCacheManager();
    private static final int MAX_COUNT = 1000000;
    private final LoadingCache<Long, List<HmilyParticipantUndo>> loadingCache = CacheBuilder.newBuilder().maximumWeight(1000000L).weigher((Long2, hmilyParticipantUndoList) -> this.getSize()).build((CacheLoader)new CacheLoader<Long, List<HmilyParticipantUndo>>(){

        public List<HmilyParticipantUndo> load(Long key) {
            return HmilyParticipantUndoCacheManager.this.cacheHmilyParticipantUndo(key);
        }
    });

    private HmilyParticipantUndoCacheManager() {
    }

    public static HmilyParticipantUndoCacheManager getInstance() {
        return INSTANCE;
    }

    public void cacheHmilyParticipantUndo(HmilyParticipantUndo hmilyParticipantUndo) {
        Long participantId = hmilyParticipantUndo.getParticipantId();
        this.cacheHmilyParticipantUndo(participantId, hmilyParticipantUndo);
    }

    public void cacheHmilyParticipantUndo(Long participantId, HmilyParticipantUndo hmilyParticipantUndo) {
        List<HmilyParticipantUndo> existList = this.get(participantId);
        if (CollectionUtils.isEmpty(existList)) {
            this.loadingCache.put((Object)participantId, (Object)Lists.newArrayList((Object[])new HmilyParticipantUndo[]{hmilyParticipantUndo}));
        } else {
            existList.add(hmilyParticipantUndo);
            this.loadingCache.put((Object)participantId, existList);
        }
    }

    private List<HmilyParticipantUndo> cacheHmilyParticipantUndo(Long participantId) {
        return Optional.ofNullable(HmilyRepositoryFacade.getInstance().findUndoByParticipantId(participantId)).orElse(Collections.emptyList());
    }

    public List<HmilyParticipantUndo> get(Long participantId) {
        try {
            return (List)this.loadingCache.get((Object)participantId);
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
    }

    public void removeByKey(Long participantId) {
        if (Objects.nonNull(participantId)) {
            this.loadingCache.invalidate((Object)participantId);
        }
    }

    private int getSize() {
        return (int)this.loadingCache.size();
    }
}

