/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.context;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.stream.Collectors;
import org.dromara.hmily.repository.spi.entity.HmilyDataSnapshot;
import org.dromara.hmily.repository.spi.entity.HmilyLock;

public class HmilyUndoContext {
    private Long participantId;
    private Long transId;
    private String resourceId;
    private HmilyDataSnapshot dataSnapshot;

    public Collection<HmilyLock> getHmilyLocks() {
        return this.dataSnapshot.getTuples().stream().map(tuple -> new HmilyLock(this.transId, this.participantId, this.resourceId, tuple.getTableName(), Joiner.on((String)"_").join((Iterable)tuple.getPrimaryKeyValues()))).collect(Collectors.toList());
    }

    public Long getParticipantId() {
        return this.participantId;
    }

    public Long getTransId() {
        return this.transId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public HmilyDataSnapshot getDataSnapshot() {
        return this.dataSnapshot;
    }

    public void setParticipantId(Long participantId) {
        this.participantId = participantId;
    }

    public void setTransId(Long transId) {
        this.transId = transId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setDataSnapshot(HmilyDataSnapshot dataSnapshot) {
        this.dataSnapshot = dataSnapshot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HmilyUndoContext)) {
            return false;
        }
        HmilyUndoContext other = (HmilyUndoContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$participantId = this.getParticipantId();
        Long other$participantId = other.getParticipantId();
        if (this$participantId == null ? other$participantId != null : !((Object)this$participantId).equals(other$participantId)) {
            return false;
        }
        Long this$transId = this.getTransId();
        Long other$transId = other.getTransId();
        if (this$transId == null ? other$transId != null : !((Object)this$transId).equals(other$transId)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
            return false;
        }
        HmilyDataSnapshot this$dataSnapshot = this.getDataSnapshot();
        HmilyDataSnapshot other$dataSnapshot = other.getDataSnapshot();
        return !(this$dataSnapshot == null ? other$dataSnapshot != null : !this$dataSnapshot.equals(other$dataSnapshot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HmilyUndoContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $participantId = this.getParticipantId();
        result = result * 59 + ($participantId == null ? 43 : ((Object)$participantId).hashCode());
        Long $transId = this.getTransId();
        result = result * 59 + ($transId == null ? 43 : ((Object)$transId).hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        HmilyDataSnapshot $dataSnapshot = this.getDataSnapshot();
        result = result * 59 + ($dataSnapshot == null ? 43 : $dataSnapshot.hashCode());
        return result;
    }

    public String toString() {
        return "HmilyUndoContext(participantId=" + this.getParticipantId() + ", transId=" + this.getTransId() + ", resourceId=" + this.getResourceId() + ", dataSnapshot=" + this.getDataSnapshot() + ")";
    }
}

