/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.handler;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.utils.DefaultValueUtils;
import org.dromara.hmily.core.cache.HmilyParticipantCacheManager;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.metrics.reporter.MetricsReporter;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.tac.core.transaction.HmilyTacParticipantCoordinator;

public class ParticipantHmilyTacTransactionHandler
implements HmilyTransactionHandler {
    private final HmilyTacParticipantCoordinator coordinator = HmilyTacParticipantCoordinator.getInstance();

    public Object handleTransaction(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        HmilyParticipant hmilyParticipant = null;
        switch (HmilyActionEnum.acquireByCode((int)context.getAction())) {
            case TRYING: {
                try {
                    hmilyParticipant = this.coordinator.beginParticipant(context, point);
                    Object proceed = point.proceed();
                    hmilyParticipant.setStatus(Integer.valueOf(HmilyActionEnum.TRYING.getCode()));
                    HmilyRepositoryStorage.updateHmilyParticipantStatus((HmilyParticipant)hmilyParticipant);
                    Object object = proceed;
                    return object;
                }
                catch (Throwable throwable) {
                    if (Objects.nonNull(hmilyParticipant)) {
                        HmilyParticipantCacheManager.getInstance().removeByKey(hmilyParticipant.getParticipantId());
                    }
                    HmilyRepositoryStorage.removeHmilyParticipant((HmilyParticipant)hmilyParticipant);
                    throw throwable;
                }
                finally {
                    HmilyContextHolder.remove();
                }
            }
            case CONFIRMING: {
                MetricsReporter.counterIncrement((String)"hmily_transaction_status", (String[])new String[]{TransTypeEnum.TAC.name(), HmilyRoleEnum.PARTICIPANT.name(), HmilyActionEnum.CONFIRMING.name()});
                List confirmList = HmilyParticipantCacheManager.getInstance().get(context.getParticipantId());
                this.coordinator.commitParticipant(confirmList, context.getParticipantId());
                break;
            }
            case CANCELING: {
                MetricsReporter.counterIncrement((String)"hmily_transaction_status", (String[])new String[]{TransTypeEnum.TAC.name(), HmilyRoleEnum.PARTICIPANT.name(), HmilyActionEnum.CANCELING.name()});
                List cancelList = HmilyParticipantCacheManager.getInstance().get(context.getParticipantId());
                this.coordinator.rollbackParticipant(cancelList, context.getParticipantId());
                break;
            }
        }
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        return DefaultValueUtils.getDefaultValue(method.getReturnType());
    }

    static {
        MetricsReporter.registerCounter((String)"hmily_transaction_status", (String[])new String[]{"type", "role", "status"}, (String)"collect hmily transaction count");
    }
}

