/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.handler;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.disruptor.HmilyDisruptor;
import org.dromara.hmily.core.disruptor.HmilyDisruptorConsumer;
import org.dromara.hmily.core.disruptor.handler.HmilyTransactionEventConsumer;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.core.service.HmilyTransactionTask;
import org.dromara.hmily.metrics.reporter.MetricsReporter;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.dromara.hmily.tac.core.transaction.HmilyTacTransactionManager;

public class StarterHmilyTacTransactionHandler
implements HmilyTransactionHandler,
AutoCloseable {
    private final HmilyTacTransactionManager tm = HmilyTacTransactionManager.getInstance();
    private final HmilyDisruptor<HmilyTransactionTask> disruptor = new HmilyDisruptor((HmilyDisruptorConsumer)new HmilyTransactionEventConsumer(), Runtime.getRuntime().availableProcessors() << 1, HmilyDisruptor.DEFAULT_SIZE.intValue());

    public StarterHmilyTacTransactionHandler() {
        this.disruptor.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object handleTransaction(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        Object returnValue;
        MetricsReporter.counterIncrement((String)"hmily_transaction_total", (String[])new String[]{TransTypeEnum.TAC.name()});
        LocalDateTime starterTime = LocalDateTime.now();
        try {
            this.tm.begin();
            try {
                returnValue = point.proceed();
            }
            catch (Throwable throwable) {
                HmilyTransaction currentTransaction = this.tm.getHmilyTransaction();
                this.disruptor.getProvider().onData(() -> {
                    MetricsReporter.counterIncrement((String)"hmily_transaction_status", (String[])new String[]{TransTypeEnum.TAC.name(), HmilyRoleEnum.START.name(), HmilyActionEnum.CANCELING.name()});
                    this.tm.rollback(currentTransaction);
                });
                throw throwable;
            }
            HmilyTransaction currentTransaction = this.tm.getHmilyTransaction();
            this.disruptor.getProvider().onData(() -> {
                MetricsReporter.counterIncrement((String)"hmily_transaction_status", (String[])new String[]{TransTypeEnum.TAC.name(), HmilyRoleEnum.START.name(), HmilyActionEnum.CONFIRMING.name()});
                this.tm.commit(currentTransaction);
            });
        }
        finally {
            HmilyContextHolder.remove();
            this.tm.remove();
            MetricsReporter.recordTime((String)"hmily_transaction_latency_histogram_millis", (long)starterTime.until(LocalDateTime.now(), ChronoUnit.MILLIS));
        }
        return returnValue;
    }

    @Override
    public void close() {
        this.disruptor.getProvider().shutdown();
    }

    static {
        MetricsReporter.registerCounter((String)"hmily_transaction_total", (String[])new String[]{"type"}, (String)"hmily transaction total count");
        MetricsReporter.registerHistogram((String)"hmily_transaction_latency_histogram_millis", (String)"hmily transaction Latency Histogram Millis (ms)");
    }
}

