/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.lock;

import java.util.Collection;
import java.util.Optional;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.repository.spi.entity.HmilyLock;
import org.dromara.hmily.repository.spi.exception.HmilyLockConflictException;
import org.dromara.hmily.tac.core.cache.HmilyLockCacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HmilyLockManager {
    INSTANCE;

    private static final Logger log;

    public void tryAcquireLocks(Collection<HmilyLock> hmilyLocks) {
        for (HmilyLock each : hmilyLocks) {
            Optional<HmilyLock> hmilyLock = HmilyLockCacheManager.getInstance().get(each.getLockId());
            if (!hmilyLock.isPresent()) continue;
            String message = String.format("current record [%s] has locked by transaction:[%s]", each.getLockId(), hmilyLock.get().getTransId());
            log.error(message);
            throw new HmilyLockConflictException(message);
        }
        HmilyRepositoryStorage.writeHmilyLocks(hmilyLocks);
        hmilyLocks.forEach(lock -> HmilyLockCacheManager.getInstance().cacheHmilyLock(lock.getLockId(), (HmilyLock)lock));
    }

    public void releaseLocks(Collection<HmilyLock> hmilyLocks) {
        HmilyRepositoryStorage.releaseHmilyLocks(hmilyLocks);
        hmilyLocks.forEach(lock -> HmilyLockCacheManager.getInstance().removeByKey(lock.getLockId()));
        log.debug("TAC-release-lock ::: {}", hmilyLocks);
    }

    static {
        log = LoggerFactory.getLogger(HmilyLockManager.class);
    }
}

