/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.transaction;

import java.util.List;
import org.dromara.hmily.core.cache.HmilyParticipantCacheManager;
import org.dromara.hmily.core.hook.UndoHook;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.repository.spi.entity.HmilyParticipantUndo;
import org.dromara.hmily.tac.core.cache.HmilyParticipantUndoCacheManager;
import org.dromara.hmily.tac.core.lock.HmilyLockManager;

public class HmilyTacLocalParticipantExecutor {
    public static void confirm(HmilyParticipant participant) {
        List<HmilyParticipantUndo> undoList = HmilyParticipantUndoCacheManager.getInstance().get(participant.getParticipantId());
        for (HmilyParticipantUndo undo : undoList) {
            HmilyTacLocalParticipantExecutor.cleanUndo(undo);
        }
        HmilyTacLocalParticipantExecutor.cleanHmilyParticipant(participant);
    }

    public static void cancel(HmilyParticipant participant) {
        List<HmilyParticipantUndo> undoList = HmilyParticipantUndoCacheManager.getInstance().get(participant.getParticipantId());
        for (HmilyParticipantUndo undo : undoList) {
            boolean success = UndoHook.INSTANCE.run(undo);
            if (!success) continue;
            HmilyTacLocalParticipantExecutor.cleanUndo(undo);
        }
        HmilyTacLocalParticipantExecutor.cleanHmilyParticipant(participant);
    }

    private static void cleanUndo(HmilyParticipantUndo hmilyParticipantUndo) {
        HmilyRepositoryStorage.removeHmilyParticipantUndo((HmilyParticipantUndo)hmilyParticipantUndo);
        HmilyParticipantUndoCacheManager.getInstance().removeByKey(hmilyParticipantUndo.getParticipantId());
        HmilyLockManager.INSTANCE.releaseLocks(hmilyParticipantUndo.getHmilyLocks());
    }

    private static void cleanHmilyParticipant(HmilyParticipant hmilyParticipant) {
        HmilyParticipantCacheManager.getInstance().removeByKey(hmilyParticipant.getParticipantId());
        HmilyRepositoryStorage.removeHmilyParticipant((HmilyParticipant)hmilyParticipant);
    }
}

