/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.transaction;

import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.ExecutorTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.core.cache.HmilyParticipantCacheManager;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.reflect.HmilyReflector;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.repository.spi.entity.HmilyInvocation;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.tac.core.transaction.HmilyTacLocalParticipantExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmilyTacParticipantCoordinator {
    private static final Logger log = LoggerFactory.getLogger(HmilyTacParticipantCoordinator.class);
    private static final HmilyTacParticipantCoordinator INSTANCE = new HmilyTacParticipantCoordinator();

    public static HmilyTacParticipantCoordinator getInstance() {
        return INSTANCE;
    }

    public HmilyParticipant beginParticipant(HmilyTransactionContext context, ProceedingJoinPoint point) {
        HmilyParticipant hmilyParticipant = this.buildHmilyParticipant(point, context.getParticipantId(), context.getParticipantRefId(), context.getTransId());
        HmilyParticipantCacheManager.getInstance().cacheHmilyParticipant(hmilyParticipant);
        HmilyRepositoryStorage.createHmilyParticipant((HmilyParticipant)hmilyParticipant);
        context.setRole(HmilyRoleEnum.PARTICIPANT.getCode());
        HmilyContextHolder.set((HmilyTransactionContext)context);
        log.debug("TAC-participate-join ::: {}", (Object)hmilyParticipant);
        return hmilyParticipant;
    }

    public void rollbackParticipant(List<HmilyParticipant> hmilyParticipantList, Long selfParticipantId) {
        if (CollectionUtils.isEmpty(hmilyParticipantList)) {
            return;
        }
        log.debug("TAC-participate-rollback ::: {}", hmilyParticipantList);
        for (HmilyParticipant participant : hmilyParticipantList) {
            try {
                if (participant.getParticipantId().equals(selfParticipantId)) {
                    HmilyTacLocalParticipantExecutor.cancel(participant);
                    continue;
                }
                HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CANCELING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)participant);
            }
            catch (Throwable e) {
                log.error("HmilyParticipant rollback exception :{} ", (Object)participant.toString());
                throw new HmilyRuntimeException(" hmilyParticipant execute rollback exception:" + participant.toString());
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
    }

    public void commitParticipant(List<HmilyParticipant> hmilyParticipantList, Long selfParticipantId) {
        if (CollectionUtils.isEmpty(hmilyParticipantList)) {
            return;
        }
        log.debug("TAC-participate-commit ::: {}", hmilyParticipantList);
        for (HmilyParticipant participant : hmilyParticipantList) {
            try {
                if (participant.getParticipantId().equals(selfParticipantId)) {
                    HmilyTacLocalParticipantExecutor.confirm(participant);
                    continue;
                }
                HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CONFIRMING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)participant);
            }
            catch (Throwable throwable) {
                throw new HmilyRuntimeException(" hmilyParticipant execute confirm exception:" + participant.toString());
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
    }

    private HmilyParticipant buildHmilyParticipant(ProceedingJoinPoint point, Long participantId, Long participantRefId, Long transId) {
        HmilyParticipant hmilyParticipant = new HmilyParticipant();
        if (null == participantId) {
            hmilyParticipant.setParticipantId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        } else {
            hmilyParticipant.setParticipantId(participantId);
        }
        if (null != participantRefId) {
            hmilyParticipant.setParticipantRefId(participantRefId);
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            Class<?> clazz = point.getTarget().getClass();
            Object[] args = point.getArgs();
            HmilyInvocation hmilyInvocation = new HmilyInvocation(clazz.getInterfaces()[0], method.getName(), (Class[])method.getParameterTypes(), args);
            hmilyParticipant.setConfirmHmilyInvocation(hmilyInvocation);
        }
        hmilyParticipant.setTransId(transId);
        hmilyParticipant.setTransType(TransTypeEnum.TAC.name());
        hmilyParticipant.setStatus(Integer.valueOf(HmilyActionEnum.PRE_TRY.getCode()));
        hmilyParticipant.setRole(HmilyRoleEnum.PARTICIPANT.getCode());
        return hmilyParticipant;
    }
}

