/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.core.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.ExecutorTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.core.reflect.HmilyReflector;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.dromara.hmily.tac.core.transaction.HmilyTacLocalParticipantExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmilyTacTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(HmilyTacTransactionManager.class);
    private static final HmilyTacTransactionManager INSTANCE = new HmilyTacTransactionManager();

    public static HmilyTacTransactionManager getInstance() {
        return INSTANCE;
    }

    public HmilyTransaction begin() {
        HmilyTransaction globalHmilyTransaction = this.createHmilyTransaction();
        HmilyRepositoryStorage.createHmilyTransaction((HmilyTransaction)globalHmilyTransaction);
        HmilyParticipant hmilyParticipant = this.buildHmilyParticipant(globalHmilyTransaction.getTransId());
        HmilyRepositoryStorage.createHmilyParticipant((HmilyParticipant)hmilyParticipant);
        globalHmilyTransaction.registerParticipant(hmilyParticipant);
        HmilyTransactionHolder.getInstance().set(globalHmilyTransaction);
        HmilyTransactionContext context = new HmilyTransactionContext();
        context.setAction(HmilyActionEnum.TRYING.getCode());
        context.setTransId(globalHmilyTransaction.getTransId());
        context.setRole(HmilyRoleEnum.START.getCode());
        context.setTransType(TransTypeEnum.TAC.name());
        context.setParticipantId(hmilyParticipant.getParticipantId());
        HmilyContextHolder.set((HmilyTransactionContext)context);
        log.debug("TAC-tm-begin ::: {}", (Object)globalHmilyTransaction);
        return globalHmilyTransaction;
    }

    public void rollback() {
        this.rollback(this.getHmilyTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(HmilyTransaction currentTransaction) {
        if (Objects.isNull(currentTransaction)) {
            return;
        }
        log.debug("TAC-tm-rollback ::: {}", (Object)currentTransaction);
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        if (CollectionUtils.isEmpty((Collection)hmilyParticipants)) {
            return;
        }
        ArrayList successList = Lists.newArrayList();
        for (HmilyParticipant participant : hmilyParticipants) {
            try {
                if (participant.getRole() == HmilyRoleEnum.START.getCode()) {
                    HmilyTacLocalParticipantExecutor.cancel(participant);
                } else {
                    HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CANCELING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)participant);
                }
                successList.add(true);
            }
            catch (Throwable e2) {
                successList.add(false);
                log.error("HmilyParticipant rollback exception :{} ", (Object)participant.toString());
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
        if (successList.stream().allMatch(e -> e)) {
            HmilyRepositoryStorage.removeHmilyTransaction((HmilyTransaction)currentTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(HmilyTransaction currentTransaction) {
        log.debug("TAC-tm-commit ::: {}", (Object)currentTransaction);
        if (Objects.isNull(currentTransaction)) {
            return;
        }
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        if (CollectionUtils.isEmpty((Collection)hmilyParticipants)) {
            return;
        }
        ArrayList successList = Lists.newArrayList();
        for (HmilyParticipant participant : hmilyParticipants) {
            try {
                if (participant.getRole() == HmilyRoleEnum.START.getCode()) {
                    HmilyTacLocalParticipantExecutor.confirm(participant);
                } else {
                    HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CONFIRMING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)participant);
                }
                successList.add(true);
            }
            catch (Throwable e2) {
                successList.add(false);
                log.error("HmilyParticipant rollback exception :{} ", (Object)participant.toString());
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
        if (successList.stream().allMatch(e -> e)) {
            HmilyRepositoryStorage.removeHmilyTransaction((HmilyTransaction)currentTransaction);
        }
    }

    public void remove() {
        HmilyTransactionHolder.getInstance().remove();
    }

    public HmilyTransaction getHmilyTransaction() {
        return HmilyTransactionHolder.getInstance().getCurrentTransaction();
    }

    private HmilyParticipant buildHmilyParticipant(Long transId) {
        HmilyParticipant hmilyParticipant = new HmilyParticipant();
        hmilyParticipant.setParticipantId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        hmilyParticipant.setTransId(transId);
        hmilyParticipant.setTransType(TransTypeEnum.TAC.name());
        hmilyParticipant.setStatus(Integer.valueOf(HmilyActionEnum.TRYING.getCode()));
        hmilyParticipant.setRole(HmilyRoleEnum.START.getCode());
        return hmilyParticipant;
    }

    private HmilyTransaction createHmilyTransaction() {
        HmilyTransaction hmilyTransaction = new HmilyTransaction();
        hmilyTransaction.setTransId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        hmilyTransaction.setStatus(HmilyActionEnum.TRYING.getCode());
        hmilyTransaction.setTransType(TransTypeEnum.TAC.name());
        return hmilyTransaction;
    }
}

