/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import org.dromara.hmily.tac.common.database.dialect.DatabaseMetaDataDialectHandler;
import org.dromara.hmily.tac.common.database.dialect.DatabaseMetaDataDialectHandlerFactory;
import org.dromara.hmily.tac.common.database.type.DatabaseType;
import org.dromara.hmily.tac.common.enums.QuoteCharacter;
import org.dromara.hmily.tac.metadata.model.ColumnMetaData;

public final class ColumnMetaDataLoader {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";

    public static Collection<ColumnMetaData> load(Connection connection, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = ColumnMetaDataLoader.loadPrimaryKeys(connection, tableNamePattern);
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        ArrayList<String> columnTypeNames = new ArrayList<String>();
        ArrayList<Boolean> isPrimaryKeys = new ArrayList<Boolean>();
        ArrayList<Boolean> isCaseSensitives = new ArrayList<Boolean>();
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), tableNamePattern, "%");){
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME);
                if (!Objects.equals(tableNamePattern, tableName)) continue;
                String columnName = resultSet.getString(COLUMN_NAME);
                columnTypes.add(resultSet.getInt(DATA_TYPE));
                columnTypeNames.add(resultSet.getString(TYPE_NAME));
                isPrimaryKeys.add(primaryKeys.contains(columnName));
                columnNames.add(columnName);
            }
        }
        resultSet = connection.createStatement().executeQuery(ColumnMetaDataLoader.generateEmptyResultSQL(tableNamePattern, databaseType));
        var11_12 = null;
        try {
            for (String each : columnNames) {
                isCaseSensitives.add(resultSet.getMetaData().isCaseSensitive(resultSet.findColumn(each)));
            }
        }
        catch (Throwable throwable) {
            var11_12 = throwable;
            throw throwable;
        }
        finally {
            if (resultSet != null) {
                if (var11_12 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        var11_12.addSuppressed(throwable);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            result.add(new ColumnMetaData((String)columnNames.get(i), (Integer)columnTypes.get(i), (String)columnTypeNames.get(i), (Boolean)isPrimaryKeys.get(i), false, (Boolean)isCaseSensitives.get(i)));
        }
        return result;
    }

    private static String generateEmptyResultSQL(String table, DatabaseType databaseType) {
        QuoteCharacter quoteCharacter = DatabaseMetaDataDialectHandlerFactory.findHandler((DatabaseType)databaseType).map(DatabaseMetaDataDialectHandler::getQuoteCharacter).orElse(QuoteCharacter.NONE);
        return String.format("SELECT * FROM %s WHERE 1 != 1", quoteCharacter.wrap(table));
    }

    private static Collection<String> loadPrimaryKeys(Connection connection, String table) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), connection.getSchema(), table);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    private ColumnMetaDataLoader() {
    }
}

