/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.dromara.hmily.tac.metadata.model.IndexMetaData;

public final class IndexMetaDataLoader {
    private static final String INDEX_NAME = "INDEX_NAME";

    public static Collection<IndexMetaData> load(Connection connection, String table) throws SQLException {
        HashSet<IndexMetaData> result = new HashSet<IndexMetaData>();
        try (ResultSet resultSet = connection.getMetaData().getIndexInfo(connection.getCatalog(), connection.getSchema(), table, false, false);){
            while (resultSet.next()) {
                String indexName = resultSet.getString(INDEX_NAME);
                if (null == indexName) continue;
                result.add(new IndexMetaData(indexName));
            }
        }
        return result;
    }

    private IndexMetaDataLoader() {
    }
}

