/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.metadata.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import org.dromara.hmily.tac.common.database.dialect.DatabaseMetaDataDialectHandlerFactory;
import org.dromara.hmily.tac.common.database.type.DatabaseType;
import org.dromara.hmily.tac.metadata.connection.MetaDataConnectionAdapter;
import org.dromara.hmily.tac.metadata.loader.ColumnMetaDataLoader;
import org.dromara.hmily.tac.metadata.loader.IndexMetaDataLoader;
import org.dromara.hmily.tac.metadata.model.TableMetaData;

public final class TableMetaDataLoader {
    public static Optional<TableMetaData> load(MetaDataConnectionAdapter connectionAdapter, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        String formattedTableNamePattern = TableMetaDataLoader.formatTableNamePattern(tableNamePattern, databaseType);
        return TableMetaDataLoader.isTableExist(connectionAdapter, formattedTableNamePattern) ? Optional.of(new TableMetaData(formattedTableNamePattern, ColumnMetaDataLoader.load(connectionAdapter, formattedTableNamePattern, databaseType), IndexMetaDataLoader.load(connectionAdapter, formattedTableNamePattern))) : Optional.empty();
    }

    private static String formatTableNamePattern(String tableNamePattern, DatabaseType databaseType) {
        return DatabaseMetaDataDialectHandlerFactory.findHandler((DatabaseType)databaseType).map(handler -> handler.formatTableNamePattern(tableNamePattern)).orElse(tableNamePattern);
    }

    private static boolean isTableExist(Connection connection, String tableNamePattern) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tableNamePattern, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    private TableMetaDataLoader() {
    }
}

