/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.metadata.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.hmily.tac.metadata.model.ColumnMetaData;
import org.dromara.hmily.tac.metadata.model.IndexMetaData;

public final class TableMetaData {
    private final String tableName;
    private final Map<String, ColumnMetaData> columns;
    private final Map<String, IndexMetaData> indexes;
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> primaryKeyColumns = new ArrayList<String>();

    public TableMetaData(String tableName, Collection<ColumnMetaData> columnMetaDataList, Collection<IndexMetaData> indexMetaDataList) {
        this.tableName = tableName;
        this.columns = this.getColumns(columnMetaDataList);
        this.indexes = this.getIndexes(indexMetaDataList);
    }

    private Map<String, ColumnMetaData> getColumns(Collection<ColumnMetaData> columnMetaDataList) {
        LinkedHashMap<String, ColumnMetaData> result = new LinkedHashMap<String, ColumnMetaData>(columnMetaDataList.size(), 1.0f);
        for (ColumnMetaData each : columnMetaDataList) {
            String lowerColumnName = each.getName().toLowerCase();
            this.columnNames.add(lowerColumnName);
            result.put(lowerColumnName, each);
            if (!each.isPrimaryKey()) continue;
            this.primaryKeyColumns.add(lowerColumnName);
        }
        return Collections.synchronizedMap(result);
    }

    private Map<String, IndexMetaData> getIndexes(Collection<IndexMetaData> indexMetaDataList) {
        LinkedHashMap<String, IndexMetaData> result = new LinkedHashMap<String, IndexMetaData>(indexMetaDataList.size(), 1.0f);
        for (IndexMetaData each : indexMetaDataList) {
            result.put(each.getName().toLowerCase(), each);
        }
        return Collections.synchronizedMap(result);
    }

    public ColumnMetaData getColumnMetaData(int columnIndex) {
        return this.columns.get(this.columnNames.get(columnIndex));
    }

    public int findColumnIndex(String columnName) {
        for (int i = 0; i < this.columnNames.size(); ++i) {
            if (!this.columnNames.get(i).equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public boolean isPrimaryKey(int columnIndex) {
        return columnIndex < this.columnNames.size() && this.columns.get(this.columnNames.get(columnIndex)).isPrimaryKey();
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, ColumnMetaData> getColumns() {
        return this.columns;
    }

    public Map<String, IndexMetaData> getIndexes() {
        return this.indexes;
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableMetaData)) {
            return false;
        }
        TableMetaData other = (TableMetaData)o;
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        Map<String, ColumnMetaData> this$columns = this.getColumns();
        Map<String, ColumnMetaData> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        Map<String, IndexMetaData> this$indexes = this.getIndexes();
        Map<String, IndexMetaData> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        List<String> this$columnNames = this.columnNames;
        List<String> other$columnNames = other.columnNames;
        if (this$columnNames == null ? other$columnNames != null : !((Object)this$columnNames).equals(other$columnNames)) {
            return false;
        }
        List<String> this$primaryKeyColumns = this.getPrimaryKeyColumns();
        List<String> other$primaryKeyColumns = other.getPrimaryKeyColumns();
        return !(this$primaryKeyColumns == null ? other$primaryKeyColumns != null : !((Object)this$primaryKeyColumns).equals(other$primaryKeyColumns));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        Map<String, ColumnMetaData> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        Map<String, IndexMetaData> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        List<String> $columnNames = this.columnNames;
        result = result * 59 + ($columnNames == null ? 43 : ((Object)$columnNames).hashCode());
        List<String> $primaryKeyColumns = this.getPrimaryKeyColumns();
        result = result * 59 + ($primaryKeyColumns == null ? 43 : ((Object)$primaryKeyColumns).hashCode());
        return result;
    }

    public String toString() {
        return "TableMetaData(tableName=" + this.getTableName() + ", columns=" + this.getColumns() + ", indexes=" + this.getIndexes() + ", columnNames=" + this.columnNames + ", primaryKeyColumns=" + this.getPrimaryKeyColumns() + ")";
    }
}

