/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.p6spy;

import com.p6spy.engine.spy.P6DataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dromara.hmily.tac.common.HmilyResourceManager;
import org.dromara.hmily.tac.common.HmilyTacResource;
import org.dromara.hmily.tac.common.database.type.DatabaseType;
import org.dromara.hmily.tac.common.database.type.DatabaseTypeFactory;
import org.dromara.hmily.tac.common.utils.DatabaseTypes;
import org.dromara.hmily.tac.common.utils.ResourceIdUtils;
import org.dromara.hmily.tac.metadata.HmilyMetaDataManager;
import org.dromara.hmily.tac.p6spy.rollback.HmilyTacRollbackExecutor;

public class HmilyP6Datasource
extends P6DataSource
implements HmilyTacResource {
    private static final long serialVersionUID = -5117674683387217309L;
    private final DataSource targetDataSource;
    private String jdbcUrl;

    public HmilyP6Datasource(DataSource delegate) {
        super(delegate);
        this.targetDataSource = delegate;
        this.init();
    }

    private void init() {
        try (Connection connection = this.targetDataSource.getConnection();){
            this.jdbcUrl = connection.getMetaData().getURL();
            DatabaseTypes.INSTANCE.setDatabaseType(DatabaseTypeFactory.getDatabaseTypeByURL((String)this.jdbcUrl));
        }
        catch (SQLException e) {
            throw new IllegalStateException("can not init dataSource", e);
        }
        HmilyMetaDataManager.register((HmilyTacResource)this, (DatabaseType)DatabaseTypes.INSTANCE.getDatabaseType());
        HmilyResourceManager.register((HmilyTacResource)this);
        HmilyTacRollbackExecutor.getInstance();
    }

    public String getResourceId() {
        return ResourceIdUtils.INSTANCE.getResourceId(this.jdbcUrl);
    }

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }
}

