/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.p6spy.executor;

import com.p6spy.engine.common.ConnectionInformation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.repository.spi.entity.HmilyDataSnapshot;
import org.dromara.hmily.repository.spi.entity.HmilyParticipantUndo;
import org.dromara.hmily.tac.common.utils.DatabaseTypes;
import org.dromara.hmily.tac.common.utils.ResourceIdUtils;
import org.dromara.hmily.tac.core.cache.HmilyParticipantUndoCacheManager;
import org.dromara.hmily.tac.core.cache.HmilyUndoContextCacheManager;
import org.dromara.hmily.tac.core.context.HmilyUndoContext;
import org.dromara.hmily.tac.core.lock.HmilyLockManager;
import org.dromara.hmily.tac.p6spy.threadlocal.AutoCommitThreadLocal;
import org.dromara.hmily.tac.sqlcompute.HmilySQLComputeEngine;
import org.dromara.hmily.tac.sqlcompute.HmilySQLComputeEngineFactory;
import org.dromara.hmily.tac.sqlparser.model.common.statement.HmilyStatement;
import org.dromara.hmily.tac.sqlparser.spi.HmilySqlParserEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HmilyExecuteTemplate {
    INSTANCE;

    private static final Logger log;

    public void beforeSetAutoCommit(Connection connection) {
        if (this.check()) {
            return;
        }
        try {
            boolean autoCommit = connection.getAutoCommit();
            if (autoCommit) {
                connection.setAutoCommit(false);
            }
            AutoCommitThreadLocal.INSTANCE.set(autoCommit);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void execute(String sql, List<Object> parameters, ConnectionInformation connectionInformation) {
        HmilyStatement statement;
        if (this.check()) {
            return;
        }
        try {
            statement = HmilySqlParserEngineFactory.newInstance().parser(sql, DatabaseTypes.INSTANCE.getDatabaseType());
            log.debug("TAC-parse-sql ::: statement: {}", (Object)statement);
        }
        catch (Exception ex) {
            return;
        }
        String resourceId = ResourceIdUtils.INSTANCE.getResourceId(connectionInformation.getUrl());
        HmilySQLComputeEngine sqlComputeEngine = HmilySQLComputeEngineFactory.newInstance((HmilyStatement)statement);
        HmilyDataSnapshot snapshot = sqlComputeEngine.execute(sql, parameters, connectionInformation.getConnection(), resourceId);
        log.debug("TAC-compute-sql ::: {}", (Object)snapshot);
        HmilyUndoContext undoContext = this.buildUndoContext(HmilyContextHolder.get(), snapshot, resourceId);
        HmilyLockManager.INSTANCE.tryAcquireLocks(undoContext.getHmilyLocks());
        log.debug("TAC-try-lock ::: {}", (Object)undoContext.getHmilyLocks());
        HmilyUndoContextCacheManager.INSTANCE.set(undoContext);
    }

    private HmilyUndoContext buildUndoContext(HmilyTransactionContext transactionContext, HmilyDataSnapshot dataSnapshot, String resourceId) {
        HmilyUndoContext result = new HmilyUndoContext();
        result.setDataSnapshot(dataSnapshot);
        result.setResourceId(resourceId);
        result.setTransId(transactionContext.getTransId());
        result.setParticipantId(transactionContext.getParticipantId());
        return result;
    }

    public void commit(Connection connection) {
        if (this.check()) {
            return;
        }
        List<HmilyParticipantUndo> undoList = this.buildUndoList();
        for (HmilyParticipantUndo undo : undoList) {
            HmilyParticipantUndoCacheManager.getInstance().cacheHmilyParticipantUndo(undo);
            HmilyRepositoryStorage.createHmilyParticipantUndo((HmilyParticipantUndo)undo);
        }
        log.debug("TAC-persist-undo ::: {}", undoList);
        this.clean(connection);
    }

    public void rollback(Connection connection) {
        if (this.check()) {
            return;
        }
        List contexts = HmilyUndoContextCacheManager.INSTANCE.get();
        LinkedList locks = new LinkedList();
        for (HmilyUndoContext context : contexts) {
            locks.addAll(context.getHmilyLocks());
        }
        HmilyLockManager.INSTANCE.releaseLocks(locks);
        this.clean(connection);
    }

    private void clean(Connection connection) {
        connection.setAutoCommit(AutoCommitThreadLocal.INSTANCE.get());
        HmilyUndoContextCacheManager.INSTANCE.remove();
        AutoCommitThreadLocal.INSTANCE.remove();
    }

    private List<HmilyParticipantUndo> buildUndoList() {
        List contexts = HmilyUndoContextCacheManager.INSTANCE.get();
        return contexts.stream().map(context -> {
            HmilyParticipantUndo undo = new HmilyParticipantUndo();
            undo.setResourceId(context.getResourceId());
            undo.setUndoId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
            undo.setParticipantId(context.getParticipantId());
            undo.setTransId(context.getTransId());
            undo.setDataSnapshot(context.getDataSnapshot());
            undo.setStatus(Integer.valueOf(HmilyActionEnum.TRYING.getCode()));
            return undo;
        }).collect(Collectors.toList());
    }

    private boolean check() {
        HmilyTransactionContext transactionContext = HmilyContextHolder.get();
        return Objects.isNull(transactionContext) || !TransTypeEnum.TAC.name().equalsIgnoreCase(transactionContext.getTransType());
    }

    static {
        log = LoggerFactory.getLogger(HmilyExecuteTemplate.class);
    }
}

