/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.p6spy.listener;

import com.p6spy.engine.common.CallableStatementInformation;
import com.p6spy.engine.common.ConnectionInformation;
import com.p6spy.engine.common.PreparedStatementInformation;
import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.common.Value;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hmily.tac.p6spy.executor.HmilyExecuteTemplate;

public class HmilyJdbcEventListener
extends SimpleJdbcEventListener {
    public void onAfterGetConnection(ConnectionInformation connectionInformation, SQLException e) {
        super.onAfterGetConnection(connectionInformation, e);
        if (Objects.isNull(e)) {
            HmilyExecuteTemplate.INSTANCE.beforeSetAutoCommit(connectionInformation.getConnection());
        }
    }

    public void onBeforeAnyExecute(StatementInformation statementInformation) {
        super.onBeforeAnyExecute(statementInformation);
        HmilyExecuteTemplate.INSTANCE.execute(statementInformation.getSql(), this.getParameters(statementInformation), statementInformation.getConnectionInformation());
    }

    public void onAfterCommit(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        super.onAfterCommit(connectionInformation, timeElapsedNanos, e);
        if (Objects.isNull(e)) {
            HmilyExecuteTemplate.INSTANCE.commit(connectionInformation.getConnection());
        } else {
            HmilyExecuteTemplate.INSTANCE.rollback(connectionInformation.getConnection());
        }
    }

    public void onAfterRollback(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        super.onAfterRollback(connectionInformation, timeElapsedNanos, e);
        HmilyExecuteTemplate.INSTANCE.rollback(connectionInformation.getConnection());
    }

    public void onAfterSetAutoCommit(ConnectionInformation connectionInformation, boolean newAutoCommit, boolean oldAutoCommit, SQLException e) {
        super.onAfterSetAutoCommit(connectionInformation, newAutoCommit, oldAutoCommit, e);
    }

    public void onAfterCallableStatementSet(CallableStatementInformation statementInformation, String parameterName, Object value, SQLException e) {
        statementInformation.setParameterValue(parameterName, value);
    }

    public void onAfterPreparedStatementSet(PreparedStatementInformation statementInformation, int parameterIndex, Object value, SQLException e) {
        statementInformation.setParameterValue(parameterIndex, value);
    }

    private List<Object> getParameters(StatementInformation statementInformation) {
        LinkedList<Object> result = new LinkedList<Object>();
        if (!(statementInformation instanceof PreparedStatementInformation)) {
            return result;
        }
        Method method = statementInformation.getClass().getDeclaredMethod("getParameterValues", new Class[0]);
        method.setAccessible(true);
        Map parameterValues = (Map)method.invoke((Object)statementInformation, new Object[0]);
        for (int i = 0; i < parameterValues.size(); ++i) {
            result.add(((Value)parameterValues.get(i)).getValue());
        }
        return result;
    }
}

