/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tcc.executor;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hmily.annotation.HmilyTCC;
import org.dromara.hmily.annotation.TransTypeEnum;
import org.dromara.hmily.common.enums.ExecutorTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.IdWorkerUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.cache.HmilyParticipantCacheManager;
import org.dromara.hmily.core.context.HmilyContextHolder;
import org.dromara.hmily.core.context.HmilyTransactionContext;
import org.dromara.hmily.core.holder.HmilyTransactionHolder;
import org.dromara.hmily.core.reflect.HmilyReflector;
import org.dromara.hmily.core.repository.HmilyRepositoryStorage;
import org.dromara.hmily.repository.spi.entity.HmilyInvocation;
import org.dromara.hmily.repository.spi.entity.HmilyParticipant;
import org.dromara.hmily.repository.spi.entity.HmilyTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HmilyTccTransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmilyTccTransactionExecutor.class);
    private static final HmilyTccTransactionExecutor INSTANCE = new HmilyTccTransactionExecutor();

    private HmilyTccTransactionExecutor() {
    }

    public static HmilyTccTransactionExecutor getInstance() {
        return INSTANCE;
    }

    public HmilyTransaction preTry(ProceedingJoinPoint point) {
        LogUtil.debug((Logger)LOGGER, () -> "......hmily tcc transaction starter....");
        HmilyTransaction hmilyTransaction = this.createHmilyTransaction();
        HmilyRepositoryStorage.createHmilyTransaction((HmilyTransaction)hmilyTransaction);
        HmilyParticipant hmilyParticipant = this.buildHmilyParticipant(point, null, null, HmilyRoleEnum.START.getCode(), hmilyTransaction.getTransId());
        HmilyRepositoryStorage.createHmilyParticipant((HmilyParticipant)hmilyParticipant);
        hmilyTransaction.registerParticipant(hmilyParticipant);
        HmilyTransactionHolder.getInstance().set(hmilyTransaction);
        HmilyTransactionContext context = new HmilyTransactionContext();
        context.setAction(HmilyActionEnum.TRYING.getCode());
        context.setTransId(hmilyTransaction.getTransId());
        context.setRole(HmilyRoleEnum.START.getCode());
        context.setTransType(TransTypeEnum.TCC.name());
        HmilyContextHolder.set((HmilyTransactionContext)context);
        return hmilyTransaction;
    }

    public HmilyParticipant preTryParticipant(HmilyTransactionContext context, ProceedingJoinPoint point) {
        LogUtil.debug((Logger)LOGGER, (String)"participant hmily tcc transaction start..\uff1a{}", () -> ((HmilyTransactionContext)context).toString());
        HmilyParticipant hmilyParticipant = this.buildHmilyParticipant(point, context.getParticipantId(), context.getParticipantRefId(), HmilyRoleEnum.PARTICIPANT.getCode(), context.getTransId());
        HmilyTransactionHolder.getInstance().cacheHmilyParticipant(hmilyParticipant);
        HmilyRepositoryStorage.createHmilyParticipant((HmilyParticipant)hmilyParticipant);
        context.setRole(HmilyRoleEnum.PARTICIPANT.getCode());
        HmilyContextHolder.set((HmilyTransactionContext)context);
        return hmilyParticipant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void globalConfirm(HmilyTransaction currentTransaction) throws HmilyRuntimeException {
        LogUtil.debug((Logger)LOGGER, () -> "hmily transaction confirm .......\uff01start");
        if (Objects.isNull(currentTransaction) || CollectionUtils.isEmpty((Collection)currentTransaction.getHmilyParticipants())) {
            return;
        }
        currentTransaction.setStatus(HmilyActionEnum.CONFIRMING.getCode());
        HmilyRepositoryStorage.updateHmilyTransactionStatus((HmilyTransaction)currentTransaction);
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        ArrayList<Boolean> successList = new ArrayList<Boolean>();
        for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
            try {
                if (hmilyParticipant.getRole() == HmilyRoleEnum.START.getCode()) {
                    HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CONFIRMING, (ExecutorTypeEnum)ExecutorTypeEnum.LOCAL, (HmilyParticipant)hmilyParticipant);
                    HmilyRepositoryStorage.removeHmilyParticipant((HmilyParticipant)hmilyParticipant);
                } else {
                    HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CONFIRMING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)hmilyParticipant);
                }
                successList.add(true);
            }
            catch (Throwable e2) {
                successList.add(false);
                LOGGER.error("HmilyParticipant confirm exception param:{} ", (Object)hmilyParticipant.toString(), (Object)e2);
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
        if (successList.stream().allMatch(e -> e)) {
            HmilyRepositoryStorage.removeHmilyTransaction((HmilyTransaction)currentTransaction);
        }
    }

    public Object participantConfirm(List<HmilyParticipant> hmilyParticipantList, Long selfParticipantId) {
        if (CollectionUtils.isEmpty(hmilyParticipantList)) {
            return null;
        }
        ArrayList results = Lists.newArrayListWithCapacity((int)hmilyParticipantList.size());
        for (HmilyParticipant hmilyParticipant : hmilyParticipantList) {
            try {
                Object result;
                if (hmilyParticipant.getParticipantId().equals(selfParticipantId)) {
                    result = HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CONFIRMING, (ExecutorTypeEnum)ExecutorTypeEnum.LOCAL, (HmilyParticipant)hmilyParticipant);
                    results.add(result);
                    HmilyRepositoryStorage.removeHmilyParticipant((HmilyParticipant)hmilyParticipant);
                    continue;
                }
                result = HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CONFIRMING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)hmilyParticipant);
                results.add(result);
            }
            catch (Throwable throwable) {
                throw new HmilyRuntimeException(" hmilyParticipant execute confirm exception:" + hmilyParticipant.toString());
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
        HmilyParticipantCacheManager.getInstance().removeByKey(selfParticipantId);
        return results.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void globalCancel(HmilyTransaction currentTransaction) {
        LogUtil.debug((Logger)LOGGER, () -> "tcc cancel ...........start!");
        if (Objects.isNull(currentTransaction) || CollectionUtils.isEmpty((Collection)currentTransaction.getHmilyParticipants())) {
            return;
        }
        currentTransaction.setStatus(HmilyActionEnum.CANCELING.getCode());
        HmilyRepositoryStorage.updateHmilyTransactionStatus((HmilyTransaction)currentTransaction);
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
            try {
                if (hmilyParticipant.getRole() == HmilyRoleEnum.START.getCode()) {
                    HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CANCELING, (ExecutorTypeEnum)ExecutorTypeEnum.LOCAL, (HmilyParticipant)hmilyParticipant);
                    HmilyRepositoryStorage.removeHmilyParticipant((HmilyParticipant)hmilyParticipant);
                    continue;
                }
                HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CANCELING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)hmilyParticipant);
            }
            catch (Throwable e) {
                LOGGER.error("HmilyParticipant cancel exception :{}", (Object)hmilyParticipant.toString(), (Object)e);
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
    }

    public Object participantCancel(List<HmilyParticipant> hmilyParticipants, Long selfParticipantId) {
        LogUtil.debug((Logger)LOGGER, () -> "tcc cancel ...........start!");
        if (CollectionUtils.isEmpty(hmilyParticipants)) {
            return null;
        }
        HmilyParticipant selfHmilyParticipant = this.filterSelfHmilyParticipant(hmilyParticipants);
        if (Objects.nonNull(selfHmilyParticipant)) {
            selfHmilyParticipant.setStatus(Integer.valueOf(HmilyActionEnum.CANCELING.getCode()));
            HmilyRepositoryStorage.updateHmilyParticipantStatus((HmilyParticipant)selfHmilyParticipant);
        }
        ArrayList results = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
        for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
            try {
                Object result;
                if (hmilyParticipant.getParticipantId().equals(selfParticipantId)) {
                    result = HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CANCELING, (ExecutorTypeEnum)ExecutorTypeEnum.LOCAL, (HmilyParticipant)hmilyParticipant);
                    results.add(result);
                    HmilyRepositoryStorage.removeHmilyParticipant((HmilyParticipant)hmilyParticipant);
                    continue;
                }
                result = HmilyReflector.executor((HmilyActionEnum)HmilyActionEnum.CANCELING, (ExecutorTypeEnum)ExecutorTypeEnum.RPC, (HmilyParticipant)hmilyParticipant);
                results.add(result);
            }
            catch (Throwable throwable) {
                throw new HmilyRuntimeException(" hmilyParticipant execute cancel exception:" + hmilyParticipant.toString());
            }
            finally {
                HmilyContextHolder.remove();
            }
        }
        HmilyParticipantCacheManager.getInstance().removeByKey(selfParticipantId);
        return results.get(0);
    }

    public void updateStartStatus(HmilyTransaction hmilyTransaction) {
        HmilyRepositoryStorage.updateHmilyTransactionStatus((HmilyTransaction)hmilyTransaction);
        HmilyParticipant hmilyParticipant = this.filterStartHmilyParticipant(hmilyTransaction);
        if (Objects.nonNull(hmilyParticipant)) {
            hmilyParticipant.setStatus(Integer.valueOf(hmilyTransaction.getStatus()));
            HmilyRepositoryStorage.updateHmilyParticipantStatus((HmilyParticipant)hmilyParticipant);
        }
    }

    public void remove() {
        HmilyTransactionHolder.getInstance().remove();
    }

    private HmilyParticipant filterStartHmilyParticipant(HmilyTransaction currentTransaction) {
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        return this.filterStartHmilyParticipant(hmilyParticipants);
    }

    private HmilyParticipant filterStartHmilyParticipant(List<HmilyParticipant> hmilyParticipants) {
        if (CollectionUtils.isNotEmpty(hmilyParticipants)) {
            return hmilyParticipants.stream().filter(e -> e.getRole() == HmilyRoleEnum.START.getCode()).findFirst().orElse(null);
        }
        return null;
    }

    private HmilyParticipant filterSelfHmilyParticipant(List<HmilyParticipant> hmilyParticipantList) {
        if (CollectionUtils.isNotEmpty(hmilyParticipantList)) {
            return hmilyParticipantList.stream().filter(e -> e.getParticipantRefId() != null).findFirst().orElse(null);
        }
        return null;
    }

    private HmilyTransaction createHmilyTransaction() {
        HmilyTransaction hmilyTransaction = new HmilyTransaction();
        hmilyTransaction.setTransId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        hmilyTransaction.setStatus(HmilyActionEnum.PRE_TRY.getCode());
        hmilyTransaction.setTransType(TransTypeEnum.TCC.name());
        return hmilyTransaction;
    }

    private HmilyParticipant buildHmilyParticipant(ProceedingJoinPoint point, Long participantId, Long participantRefId, int role, Long transId) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Object[] args = point.getArgs();
        HmilyTCC hmilyTCC = method.getAnnotation(HmilyTCC.class);
        String confirmMethodName = hmilyTCC.confirmMethod();
        String cancelMethodName = hmilyTCC.cancelMethod();
        if (StringUtils.isBlank((CharSequence)confirmMethodName) || StringUtils.isBlank((CharSequence)cancelMethodName)) {
            return null;
        }
        HmilyParticipant hmilyParticipant = new HmilyParticipant();
        if (null == participantId) {
            hmilyParticipant.setParticipantId(Long.valueOf(IdWorkerUtils.getInstance().createUUID()));
        } else {
            hmilyParticipant.setParticipantId(participantId);
        }
        if (null != participantRefId) {
            hmilyParticipant.setParticipantRefId(participantRefId);
        }
        Class<?> clazz = point.getTarget().getClass();
        hmilyParticipant.setTransId(transId);
        hmilyParticipant.setTransType(TransTypeEnum.TCC.name());
        hmilyParticipant.setStatus(Integer.valueOf(HmilyActionEnum.PRE_TRY.getCode()));
        hmilyParticipant.setRole(role);
        hmilyParticipant.setTargetClass(clazz.getName());
        hmilyParticipant.setTargetMethod(method.getName());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{confirmMethodName})) {
            hmilyParticipant.setConfirmMethod(confirmMethodName);
            HmilyInvocation confirmInvocation = new HmilyInvocation(clazz.getInterfaces()[0], method.getName(), (Class[])method.getParameterTypes(), args);
            hmilyParticipant.setConfirmHmilyInvocation(confirmInvocation);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cancelMethodName})) {
            hmilyParticipant.setCancelMethod(cancelMethodName);
            HmilyInvocation cancelInvocation = new HmilyInvocation(clazz.getInterfaces()[0], method.getName(), (Class[])method.getParameterTypes(), args);
            hmilyParticipant.setCancelHmilyInvocation(cancelInvocation);
        }
        return hmilyParticipant;
    }
}

